/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.html.emf;

import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.nasdanika.common.BiSupplier;
import org.nasdanika.common.CollectionCompoundConsumer;
import org.nasdanika.common.Consumer;
import org.nasdanika.common.Context;
import org.nasdanika.common.ExecutionException;
import org.nasdanika.common.ExecutionParticipant;
import org.nasdanika.common.ProgressMonitor;
import org.nasdanika.common.Util;
import org.nasdanika.emf.DiagnosticProvider;
import org.nasdanika.emf.EObjectAdaptable;
import org.nasdanika.exec.content.ContentFactory;
import org.nasdanika.html.Event;
import org.nasdanika.html.HTMLFactory;
import org.nasdanika.html.RowContainer;
import org.nasdanika.html.Table;
import org.nasdanika.html.Tag;
import org.nasdanika.html.TagName;
import org.nasdanika.html.bootstrap.Color;
import org.nasdanika.html.emf.ColumnBuilder;
import org.nasdanika.html.emf.DynamicColumnBuilder;
import org.nasdanika.html.emf.EObjectActionResolver;
import org.nasdanika.html.emf.GitLinkResolver;
import org.nasdanika.html.model.app.Action;
import org.nasdanika.html.model.app.AppFactory;
import org.nasdanika.html.model.app.Label;
import org.nasdanika.html.model.app.Link;
import org.nasdanika.html.model.app.NavigationPanel;
import org.nasdanika.html.model.app.util.ActionBuilder;
import org.nasdanika.html.model.app.util.ActionProvider;
import org.nasdanika.html.model.bootstrap.Alert;
import org.nasdanika.html.model.bootstrap.Appearance;
import org.nasdanika.html.model.bootstrap.BootstrapFactory;
import org.nasdanika.html.model.bootstrap.TableCell;
import org.nasdanika.html.model.bootstrap.TableHeader;
import org.nasdanika.html.model.bootstrap.TableRow;
import org.nasdanika.html.model.bootstrap.TableSection;
import org.nasdanika.html.model.bootstrap.Text;
import org.nasdanika.html.model.html.HtmlFactory;
import org.nasdanika.html.model.html.Script;
import org.nasdanika.ncore.GitMarker;
import org.nasdanika.ncore.List;
import org.nasdanika.ncore.Map;
import org.nasdanika.ncore.Marked;
import org.nasdanika.ncore.Marker;
import org.nasdanika.ncore.ModelElement;
import org.nasdanika.ncore.NcoreFactory;
import org.nasdanika.ncore.NcorePackage;
import org.nasdanika.ncore.Period;
import org.nasdanika.ncore.Temporal;
import org.nasdanika.ncore.util.NcoreUtil;

public class EObjectActionBuilder<T extends EObject>
extends AdapterImpl
implements ActionBuilder {
    protected Context context;

    public EObjectActionBuilder(T target, Context context) {
        this.setTarget((Notifier)target);
        this.context = context;
    }

    public T getTarget() {
        return (T)((EObject)super.getTarget());
    }

    public Action execute(BiSupplier<Action, BiConsumer<EObject, Action>> actionAndRegistry, ProgressMonitor progressMonitor) {
        EObjectActionResolverAdapter resolver = new EObjectActionResolverAdapter();
        BiConsumer registry = (BiConsumer)actionAndRegistry.getSecond();
        Action ret = this.buildAction((Action)actionAndRegistry.getFirst(), registry, resolver::add, progressMonitor);
        registry.accept(this.getTarget(), ret);
        ret.eAdapters().add((Object)resolver);
        return ret;
    }

    protected Action buildAction(Action action, BiConsumer<EObject, Action> registry, java.util.function.Consumer<Consumer<EObjectActionResolver.Context>> resolveConsumer, ProgressMonitor progressMonitor) {
        Action ret = action == null ? this.newAction(registry, resolveConsumer, progressMonitor) : action;
        Collection<Diagnostic> diagnostic = this.getDiagnostic();
        int severity = 0;
        for (Diagnostic de : diagnostic) {
            severity = Math.max(severity, de.getSeverity());
        }
        if (severity > 0) {
            ret.setColor(EObjectActionBuilder.getSeverityColor(severity));
        }
        for (Diagnostic de : diagnostic) {
            Alert diagnosticAlert = BootstrapFactory.eINSTANCE.createAlert();
            diagnosticAlert.setColor(EObjectActionBuilder.getSeverityColor(de.getSeverity()));
            diagnosticAlert.getContent().add((Object)EObjectActionBuilder.createText(StringEscapeUtils.escapeHtml4((String)de.getMessage())));
            ret.getContent().add((Object)diagnosticAlert);
        }
        return ret;
    }

    protected Action newAction(BiConsumer<EObject, Action> registry, java.util.function.Consumer<Consumer<EObjectActionResolver.Context>> resolveConsumer, ProgressMonitor progressMonitor) {
        T semanticElement = this.getTarget();
        if (semanticElement instanceof ModelElement) {
            EObject actionPrototype = ((ModelElement)semanticElement).getActionPrototype();
            if (actionPrototype instanceof Action) {
                Action copy = (Action)EcoreUtil.copy((EObject)((Action)actionPrototype));
                copy.setUuid(UUID.randomUUID().toString());
                TreeIterator cit = copy.eAllContents();
                while (cit.hasNext()) {
                    EObject next = (EObject)cit.next();
                    if (!(next instanceof ModelElement)) continue;
                    ((ModelElement)next).setUuid(UUID.randomUUID().toString());
                }
                return copy;
            }
            if (actionPrototype != null) {
                ActionProvider actionProvider = Objects.requireNonNull((ActionProvider)EcoreUtil.getRegisteredAdapter((EObject)actionPrototype, ActionProvider.class), "Cannot adapt " + actionPrototype + " to " + ActionProvider.class);
                Action ret = (Action)actionProvider.execute(registry, progressMonitor);
                ret.setUuid(UUID.randomUUID().toString());
                TreeIterator cit = ret.eAllContents();
                while (cit.hasNext()) {
                    EObject next = (EObject)cit.next();
                    if (!(next instanceof ModelElement)) continue;
                    ((ModelElement)next).setUuid(UUID.randomUUID().toString());
                }
                return ret;
            }
        }
        return AppFactory.eINSTANCE.createAction();
    }

    protected NavigationPanel createLeftNavigation(EObjectActionResolver.Context context, ProgressMonitor progressMonitor) {
        return null;
    }

    protected NavigationPanel createRightNavigation(EObjectActionResolver.Context context, ProgressMonitor progressMonitor) {
        return null;
    }

    protected NavigationPanel createFloatLeftNavigation(EObjectActionResolver.Context context, ProgressMonitor progressMonitor) {
        return null;
    }

    protected NavigationPanel createFloatRightNavigation(EObjectActionResolver.Context context, ProgressMonitor progressMonitor) {
        return null;
    }

    protected Collection<Diagnostic> getDiagnostic() {
        Adapter adapter = EcoreUtil.getRegisteredAdapter(this.getTarget(), DiagnosticProvider.class);
        return adapter instanceof DiagnosticProvider ? ((DiagnosticProvider)adapter).getDiagnostic() : Collections.emptyList();
    }

    protected Action createDiagnosticAction(Action action, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) {
        return null;
    }

    protected Collection<Diagnostic> getFeatureDiagnostic(EStructuralFeature feature) {
        Adapter adapter = EcoreUtil.getRegisteredAdapter(this.getTarget(), DiagnosticProvider.class);
        return adapter instanceof DiagnosticProvider ? ((DiagnosticProvider)adapter).getFeatureDiagnostic(feature) : Collections.emptyList();
    }

    protected void resolve(Action action, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) {
        org.nasdanika.html.model.bootstrap.Table propertiesTable;
        action.setLeftNavigation(this.createLeftNavigation(context, progressMonitor));
        action.setFloatLeftNavigation(this.createFloatLeftNavigation(context, progressMonitor));
        action.setRightNavigation(this.createRightNavigation(context, progressMonitor));
        action.setFloatRightNavigation(this.createFloatRightNavigation(context, progressMonitor));
        Action diagnosticAction = this.createDiagnosticAction(action, context, progressMonitor);
        if (diagnosticAction != null) {
            action.getNavigation().add((Object)diagnosticAction);
        }
        if ((propertiesTable = this.createPropertiesTable(action, context, progressMonitor)) != null) {
            Action infoAction = AppFactory.eINSTANCE.createAction();
            infoAction.setIcon("fas fa-info-circle");
            infoAction.setText("Info");
            infoAction.getContent().add((Object)propertiesTable);
            infoAction.setLocation("info." + this.getHtmlExtension());
            action.getNavigation().add((Object)infoAction);
        }
    }

    protected String getHtmlExtension() {
        return "html";
    }

    protected org.nasdanika.html.model.bootstrap.Table createPropertiesTable(Action action, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) {
        java.util.List<ETypedElement> properties = this.getProperties();
        if (properties == null || properties.isEmpty()) {
            return null;
        }
        org.nasdanika.html.model.bootstrap.Table ret = BootstrapFactory.eINSTANCE.createTable();
        EList rows = ret.getRows();
        for (ETypedElement property : properties) {
            EObject renderedValue;
            boolean isSetOrNotEmpty;
            Object propertyValue = this.getTypedElementValue(property);
            java.util.List<Diagnostic> featureDiagnostic = property instanceof EStructuralFeature ? this.getFeatureDiagnostic((EStructuralFeature)property) : Collections.emptyList();
            int severity = 0;
            for (Diagnostic diagnostic : featureDiagnostic) {
                severity = Math.max(severity, diagnostic.getSeverity());
            }
            boolean bl = property instanceof EStructuralFeature && ((EStructuralFeature)property).isChangeable() ? this.isSet((EStructuralFeature)property) : (isSetOrNotEmpty = !this.isEmptyValue(property, propertyValue));
            if (!isSetOrNotEmpty && featureDiagnostic.isEmpty()) continue;
            TableRow propertyRow = BootstrapFactory.eINSTANCE.createTableRow();
            rows.add((Object)propertyRow);
            EList propertyCells = propertyRow.getCells();
            TableCell propertyHeader = BootstrapFactory.eINSTANCE.createTableCell();
            propertyHeader.setHeader(true);
            propertyCells.add((Object)propertyHeader);
            propertyHeader.getContent().add((Object)this.createETypedElementLabel(property, false));
            if (severity > 0) {
                Appearance headerAppearance = BootstrapFactory.eINSTANCE.createAppearance();
                propertyHeader.setAppearance(headerAppearance);
                Text aText = BootstrapFactory.eINSTANCE.createText();
                headerAppearance.setText(aText);
                aText.setColor(EObjectActionBuilder.getSeverityColor(severity));
            }
            TableCell propertyValueCell = BootstrapFactory.eINSTANCE.createTableCell();
            propertyCells.add((Object)propertyValueCell);
            if (isSetOrNotEmpty && (renderedValue = this.renderValue(action, property, propertyValue, context, progressMonitor)) != null) {
                propertyValueCell.getContent().add((Object)renderedValue);
            }
            for (Diagnostic diagnostic : featureDiagnostic) {
                Alert diagnosticAlert = BootstrapFactory.eINSTANCE.createAlert();
                diagnosticAlert.setColor(EObjectActionBuilder.getSeverityColor(diagnostic.getSeverity()));
                diagnosticAlert.getContent().add((Object)EObjectActionBuilder.createText(StringEscapeUtils.escapeHtml4((String)diagnostic.getMessage())));
                propertyValueCell.getContent().add((Object)diagnosticAlert);
            }
        }
        return ret;
    }

    protected boolean isSet(EStructuralFeature feature) {
        if (feature == NcorePackage.Literals.MODEL_ELEMENT__URIS) {
            return !NcoreUtil.getUris(this.getTarget()).isEmpty();
        }
        return this.getTarget().eIsSet(feature);
    }

    protected java.util.List<ETypedElement> getProperties() {
        ArrayList<ETypedElement> properties = new ArrayList<ETypedElement>();
        if (this.getTarget() instanceof Marked) {
            properties.add((ETypedElement)NcorePackage.Literals.MARKED__MARKERS);
        }
        if (this.getTarget() instanceof ModelElement) {
            properties.add((ETypedElement)NcorePackage.Literals.MODEL_ELEMENT__URIS);
        }
        if (this.getTarget() instanceof Period) {
            properties.add((ETypedElement)NcorePackage.Literals.PERIOD__START);
            properties.add((ETypedElement)NcorePackage.Literals.PERIOD__END);
            properties.add((ETypedElement)NcorePackage.Literals.PERIOD__DURATION);
        }
        return properties;
    }

    protected Label createETypedElementLabel(ETypedElement eTypedElement, boolean inModal) {
        Label label = AppFactory.eINSTANCE.createLabel();
        this.configureETypedElementLabel(eTypedElement, label, inModal);
        return label;
    }

    protected void configureETypedElementLabel(ETypedElement eTypedElement, Label label, boolean inModal) {
        label.setText(this.typedElementLabelText(eTypedElement));
        label.setIcon(this.typedElementIcon(eTypedElement));
    }

    protected String typedElementLabelText(ETypedElement type) {
        EMap remotes;
        EList markers;
        if (type == NcorePackage.Literals.MARKED__MARKERS && (markers = (EList)this.getTarget().eGet((EStructuralFeature)type)) != null && markers.size() == 1 && markers.get(0) instanceof GitMarker && (remotes = ((GitMarker)markers.get(0)).getRemotes()).size() == 1) {
            return StringUtils.capitalize((String)((String)((Map.Entry)remotes.get(0)).getKey()));
        }
        return NcoreUtil.getNasdanikaAnnotationDetail((EModelElement)type, (String)"label", (String)Util.nameToLabel((String)type.getName()));
    }

    protected String typedElementIcon(ETypedElement member) {
        return NcoreUtil.getNasdanikaAnnotationDetail((EModelElement)member, (String)"icon", (String)NcoreUtil.getNasdanikaAnnotationDetail((EModelElement)member.getEType(), (String)"icon"));
    }

    protected ActionProvider adaptChild(EObject child) {
        return (ActionProvider)EObjectAdaptable.adaptTo((EObject)child, ActionProvider.class);
    }

    protected Action createChildAction(EObject child, BiConsumer<EObject, Action> registry, java.util.function.Consumer<Consumer<EObjectActionResolver.Context>> resolveConsumer, ProgressMonitor progressMonitor) {
        Adapter childResolver;
        ActionProvider provider = this.adaptChild(child);
        if (provider == null) {
            return null;
        }
        Action ret = (Action)provider.execute(registry, progressMonitor);
        if (ret != null && resolveConsumer != null && (childResolver = EcoreUtil.getExistingAdapter((Notifier)ret, EObjectActionResolver.class)) instanceof EObjectActionResolver) {
            resolveConsumer.accept((EObjectActionResolver)childResolver);
        }
        return ret;
    }

    public double size() {
        return 1.0;
    }

    public String name() {
        return "Action provider for " + this.getTarget();
    }

    protected boolean isEmptyValue(ETypedElement member, Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Collection) {
            return ((Collection)value).isEmpty();
        }
        if (value instanceof String) {
            return Util.isBlank((String)((String)value));
        }
        if (value instanceof Number) {
            if (value.equals(0)) {
                return true;
            }
            if (value instanceof Double) {
                if (((Double)value).isNaN()) {
                    return true;
                }
                return Math.abs((Double)value) < 9.9E-324;
            }
            if (value instanceof Float) {
                if (((Float)value).isNaN()) {
                    return true;
                }
                return Math.abs(((Float)value).floatValue()) < 2.8E-45f;
            }
        }
        if (value instanceof Temporal) {
            Temporal temporal = (Temporal)value;
            return temporal.getInstant() == null && temporal.getBase() == null && temporal.getLowerBounds().isEmpty() && temporal.getUpperBounds().isEmpty();
        }
        return Boolean.FALSE.equals(value);
    }

    protected Object getTypedElementValue(ETypedElement typedElement) {
        return this.getTypedElementValue((EObject)this.getTarget(), typedElement);
    }

    protected Object getTypedElementValue(EObject eObject, ETypedElement typedElement) {
        if (typedElement == EcorePackage.Literals.EOBJECT___ECONTAINER) {
            return eObject.eContainer();
        }
        if (typedElement == NcorePackage.Literals.MODEL_ELEMENT__URIS) {
            return NcoreUtil.getUris((EObject)eObject);
        }
        if (typedElement instanceof EStructuralFeature) {
            return eObject.eGet((EStructuralFeature)typedElement);
        }
        EOperation eOp = (EOperation)typedElement;
        try {
            return eObject.eInvoke(eOp, this.getArguments(eObject, eOp));
        }
        catch (InvocationTargetException e) {
            throw new ExecutionException((Throwable)e, (ExecutionParticipant)this);
        }
    }

    protected EList<?> getArguments(EObject eObject, EOperation eOp) {
        if (eOp.getEParameters().isEmpty()) {
            return ECollections.emptyEList();
        }
        throw new UnsupportedOperationException();
    }

    protected static void addContent(Action action, String content) {
        if (!Util.isBlank((String)content)) {
            org.nasdanika.exec.content.Text text = EObjectActionBuilder.createText(content);
            action.getContent().add((Object)text);
        }
    }

    public static org.nasdanika.exec.content.Text createText(String content) {
        org.nasdanika.exec.content.Text text = ContentFactory.eINSTANCE.createText();
        text.setContent(content);
        return text;
    }

    protected EObject gitRemoteLink(GitMarker marker, String remoteUrl) {
        GitLinkResolver gitLinkResolver = null;
        if (this.context != null) {
            gitLinkResolver = (GitLinkResolver)this.context.get(GitLinkResolver.class);
        }
        if (gitLinkResolver == null) {
            gitLinkResolver = GitLinkResolver.INSTANCE;
        }
        String remoteLocation = gitLinkResolver.resolve(marker, remoteUrl);
        String position = marker.getPosition();
        EList headRefs = marker.getHeadRefs();
        if (remoteLocation == null) {
            Table table = HTMLFactory.INSTANCE.table();
            RowContainer.Row remoteRow = table.row(new Object[0]);
            remoteRow.header(new Object[]{"Remote"});
            remoteRow.cell(new Object[]{remoteUrl});
            RowContainer.Row pathRow = table.row(new Object[0]);
            pathRow.header(new Object[]{"Path"});
            pathRow.cell(new Object[]{marker.getPath()});
            if (!Util.isBlank((String)position)) {
                RowContainer.Row positionRow = table.row(new Object[0]);
                positionRow.header(new Object[]{"Positon"});
                positionRow.cell(new Object[]{position});
            }
            if (!headRefs.isEmpty()) {
                RowContainer.Row refsRow = table.row(new Object[0]);
                refsRow.header(new Object[]{"Refs"});
                if (headRefs.size() == 1) {
                    refsRow.cell(new Object[]{headRefs.get(0)});
                } else {
                    refsRow.cell(new Object[]{HTMLFactory.INSTANCE.ul((Iterable)headRefs)});
                }
            }
            return EObjectActionBuilder.createText(table.toString());
        }
        StringBuilder textBuilder = new StringBuilder(marker.getPath());
        if (!Util.isBlank((String)position)) {
            textBuilder.append(" ").append(position);
        }
        Link link = AppFactory.eINSTANCE.createLink();
        link.setText(textBuilder.toString());
        link.setLocation(remoteLocation);
        if (!headRefs.isEmpty()) {
            link.setTooltip(String.join((CharSequence)", ", (Iterable<? extends CharSequence>)headRefs));
        }
        if (remoteUrl.startsWith("https://github.com")) {
            link.setIcon("fab fa-github");
        }
        return link;
    }

    protected EObject renderValue(Action base, ETypedElement typedElement, Object value, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) {
        GitMarker marker;
        if (this.isEmptyValue(typedElement, value)) {
            return null;
        }
        if (value instanceof Instant) {
            return this.renderValue(base, typedElement, new Date(((Instant)value).toEpochMilli()), context, progressMonitor);
        }
        if (value == Boolean.TRUE) {
            return EObjectActionBuilder.createText("<i class=\"fas fa-check\"></i>");
        }
        if (value instanceof Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)value);
            String datePart = DateFormat.getDateInstance(2, Locale.getDefault()).format((Date)value);
            if (calendar.get(11) == 0 && calendar.get(12) == 0 && calendar.get(13) == 0) {
                return EObjectActionBuilder.createText(datePart);
            }
            String timePart = DateFormat.getTimeInstance().format((Date)value);
            return EObjectActionBuilder.createText(datePart + " " + timePart);
        }
        if (value instanceof GitMarker) {
            marker = (GitMarker)value;
            EMap remotes = marker.getRemotes();
            if (remotes.size() == 1) {
                return this.gitRemoteLink(marker, (String)((Map.Entry)remotes.get(0)).getValue());
            }
            if (!remotes.isEmpty()) {
                throw new UnsupportedOperationException("Multiple remotes are not yet supported");
            }
        }
        if (value instanceof Marker) {
            marker = (Marker)value;
            StringBuilder textBuilder = new StringBuilder(marker.getLocation());
            String position = marker.getPosition();
            if (!Util.isBlank((String)position)) {
                textBuilder.append(" ").append(position);
            }
            return EObjectActionBuilder.createText(textBuilder.toString());
        }
        if (value instanceof Temporal) {
            return this.temporalValue(base, typedElement, (Temporal)value, context, progressMonitor);
        }
        if (value instanceof Duration) {
            return EObjectActionBuilder.createText(Temporal.formatDuration((Duration)((Duration)value)));
        }
        if (value instanceof EObject) {
            Action valueAction = context.getAction((EObject)value);
            if (valueAction == null) {
                return EcoreUtil.copy((EObject)((EObject)value));
            }
            URI location = context.resolve(valueAction, base);
            Label label = location == null ? AppFactory.eINSTANCE.createLabel() : AppFactory.eINSTANCE.createLink();
            label.setText(valueAction.getText());
            label.setIcon(valueAction.getIcon());
            label.setTooltip(valueAction.getTooltip());
            if (label instanceof Link) {
                ((Link)label).setLocation(location.toString());
            }
            return label;
        }
        if (value instanceof EMap) {
            return this.createEMapTable(typedElement, (EMap)value, base, context, progressMonitor);
        }
        if (value instanceof Collection) {
            Collection vc = (Collection)value;
            if (vc.isEmpty()) {
                return null;
            }
            if (vc.size() == 1) {
                return this.renderValue(base, typedElement, vc.iterator().next(), context, progressMonitor);
            }
            return this.renderList((Collection)value, true, null, base, typedElement, context, progressMonitor);
        }
        if (typedElement == NcorePackage.Literals.MODEL_ELEMENT__URIS) {
            HTMLFactory htmlFactory = HTMLFactory.INSTANCE;
            Tag clipboardIcon = (Tag)((Tag)((Tag)((Tag)htmlFactory.tag(TagName.i, new Object[0]).addClass(new Object[]{"far", "fa-copy", "nsd-copy-to-clipboard"})).style("cursor", (Object)"pointer")).attribute("title", (Object)"Copy URI to clipboard")).on(Event.click, (Object)("navigator.clipboard.writeText(\"" + StringEscapeUtils.escapeHtml4((String)String.valueOf(value)) + "\")"));
            return EObjectActionBuilder.createText(value + " " + clipboardIcon);
        }
        return EObjectActionBuilder.createText(String.valueOf(value));
    }

    protected <E> org.nasdanika.html.model.html.Tag renderList(Collection<E> elements, boolean ordered, ContentProvider<E> contentProvider, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) {
        if (elements == null || elements.isEmpty()) {
            return null;
        }
        org.nasdanika.html.model.html.Tag ol = HtmlFactory.eINSTANCE.createTag();
        ol.setName(ordered ? "ol" : "ul");
        for (E element : elements) {
            java.util.List<EObject> content;
            org.nasdanika.html.model.html.Tag li = HtmlFactory.eINSTANCE.createTag();
            li.setName("li");
            ol.getContent().add((Object)li);
            li.getContent().add((Object)this.renderValue(base, typedElement, element, context, progressMonitor));
            if (contentProvider == null || (content = contentProvider.createContent(element, base, typedElement, context, progressMonitor)) == null) continue;
            li.getContent().addAll(content);
        }
        return ol;
    }

    protected org.nasdanika.html.model.bootstrap.Table createEMapTable(ETypedElement typedElement, EMap<?, ?> eMap, Action action, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) {
        if (eMap == null || eMap.isEmpty()) {
            return null;
        }
        org.nasdanika.html.model.bootstrap.Table ret = BootstrapFactory.eINSTANCE.createTable();
        EList rows = ret.getRows();
        for (Object key : this.sortKeys(eMap.keySet())) {
            Object value = eMap.get(key);
            TableRow entryRow = BootstrapFactory.eINSTANCE.createTableRow();
            rows.add((Object)entryRow);
            EList entryCells = entryRow.getCells();
            TableCell keyHeader = BootstrapFactory.eINSTANCE.createTableCell();
            keyHeader.setHeader(true);
            entryCells.add((Object)keyHeader);
            keyHeader.getContent().add((Object)EObjectActionBuilder.createText(String.valueOf(key)));
            TableCell valueCell = BootstrapFactory.eINSTANCE.createTableCell();
            entryCells.add((Object)valueCell);
            EObject renderedValue = this.renderValue(action, typedElement, value, context, progressMonitor);
            if (renderedValue == null) continue;
            valueCell.getContent().add((Object)renderedValue);
        }
        return ret;
    }

    protected <K> java.util.List<K> sortKeys(Set<K> keys) {
        return keys.stream().sorted((a, b) -> String.valueOf(a).compareTo(String.valueOf(b))).collect(Collectors.toList());
    }

    protected ColumnBuilder<EObject> createColumnBuilder(ETypedElement typedElement) {
        return this.createColumnBuilder(typedElement, (EObject)this.createETypedElementLabel(typedElement, false));
    }

    protected ColumnBuilder<EObject> createColumnBuilder(ETypedElement typedElement, String label) {
        return this.createColumnBuilder(typedElement, (EObject)EObjectActionBuilder.createText(label));
    }

    protected ColumnBuilder<EObject> createColumnBuilder(final ETypedElement typedElement, final EObject label) {
        return new ColumnBuilder<EObject>(){

            @Override
            public void buildHeader(TableCell header, Action base, ETypedElement tElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) {
                header.getContent().add((Object)label);
            }

            @Override
            public void buildCell(EObject rowElement, TableCell cell, Action base, ETypedElement tElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) {
                Object value = EObjectActionBuilder.this.getTypedElementValue(rowElement, typedElement);
                EObject renderedValue = EObjectActionBuilder.this.renderValue(base, typedElement, value, context, progressMonitor);
                if (renderedValue != null) {
                    cell.getContent().add((Object)renderedValue);
                }
            }
        };
    }

    protected ColumnBuilder<EObject> createColumnBuilder(String label) {
        return this.createColumnBuilder((EObject)EObjectActionBuilder.createText(label));
    }

    protected ColumnBuilder<EObject> createColumnBuilder(final EObject label) {
        return new ColumnBuilder<EObject>(){

            @Override
            public void buildHeader(TableCell header, Action base, ETypedElement tElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) {
                header.getContent().add((Object)label);
            }

            @Override
            public void buildCell(EObject rowElement, TableCell cell, Action base, ETypedElement tElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) {
                EObject renderedValue = EObjectActionBuilder.this.renderValue(base, null, rowElement, context, progressMonitor);
                if (renderedValue != null) {
                    cell.getContent().add((Object)renderedValue);
                }
            }
        };
    }

    protected java.util.List<ColumnBuilder<? super EObject>> createColumnBuilders(Collection<ETypedElement> typedElements) {
        return typedElements.stream().map(this::createColumnBuilder).collect(Collectors.toList());
    }

    protected java.util.List<ColumnBuilder<? super EObject>> createColumnBuilders(ETypedElement ... typedElements) {
        return this.createColumnBuilders(Arrays.asList(typedElements));
    }

    @SafeVarargs
    public static <T> org.nasdanika.html.model.bootstrap.Table buildTable(Collection<? extends T> elements, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor, ColumnBuilder<? super T> ... columnBuilders) {
        return EObjectActionBuilder.buildTable(elements, Arrays.asList(columnBuilders), base, typedElement, context, progressMonitor);
    }

    public static <T> org.nasdanika.html.model.bootstrap.Table buildTable(Collection<? extends T> elements, Collection<ColumnBuilder<? super T>> columnBuilders, Action base, ETypedElement typedElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) {
        org.nasdanika.html.model.bootstrap.Table ret = BootstrapFactory.eINSTANCE.createTable();
        TableHeader header = BootstrapFactory.eINSTANCE.createTableHeader();
        ret.setHeader(header);
        TableRow headerRow = BootstrapFactory.eINSTANCE.createTableRow();
        header.getRows().add((Object)headerRow);
        EList headerRowCells = headerRow.getCells();
        for (ColumnBuilder<T> cb : columnBuilders) {
            TableCell headerCell = BootstrapFactory.eINSTANCE.createTableCell();
            headerCell.setHeader(true);
            headerRowCells.add((Object)headerCell);
            cb.buildHeader(headerCell, base, typedElement, context, progressMonitor);
        }
        TableSection body = BootstrapFactory.eINSTANCE.createTableSection();
        ret.setBody(body);
        EList bodyRows = body.getRows();
        for (T element : elements) {
            TableRow elementRow = BootstrapFactory.eINSTANCE.createTableRow();
            bodyRows.add((Object)elementRow);
            EList elementRowCells = elementRow.getCells();
            for (ColumnBuilder<T> cb : columnBuilders) {
                TableCell elementCell = BootstrapFactory.eINSTANCE.createTableCell();
                elementRowCells.add((Object)elementCell);
                cb.buildCell(element, elementCell, base, typedElement, context, progressMonitor);
            }
        }
        return ret;
    }

    protected DynamicColumnBuilder<EObject> createDynamicColumnBuilder(ETypedElement typedElement, boolean visible) {
        return this.createDynamicColumnBuilder(typedElement, (EObject)this.createETypedElementLabel(typedElement, false), visible);
    }

    protected DynamicColumnBuilder<EObject> createDynamicColumnBuilder(ETypedElement typedElement, String label, boolean visible) {
        return this.createDynamicColumnBuilder(typedElement, (EObject)EObjectActionBuilder.createText(label), visible);
    }

    protected DynamicColumnBuilder<EObject> createDynamicColumnBuilder(final ETypedElement typedElement, final EObject label, final boolean visible) {
        return new DynamicColumnBuilder<EObject>(){

            @Override
            public Map buildHeader(Action base, ETypedElement tElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) {
                Map header = NcoreFactory.eINSTANCE.createMap();
                if (visible) {
                    header.put("visible", visible);
                }
                header.put("key", typedElement.getName());
                header.put("label", label);
                return header;
            }

            @Override
            public void buildCell(EObject rowElement, Map row, Action base, ETypedElement tElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) {
                Object value = EObjectActionBuilder.this.getTypedElementValue(rowElement, typedElement);
                EObject renderedValue = EObjectActionBuilder.this.renderValue(base, typedElement, value, context, progressMonitor);
                if (renderedValue != null) {
                    row.put(typedElement.getName(), renderedValue);
                }
            }
        };
    }

    protected DynamicColumnBuilder<EObject> createDynamicColumnBuilder(String label, boolean visible) {
        return this.createDynamicColumnBuilder((EObject)EObjectActionBuilder.createText(label), visible);
    }

    protected DynamicColumnBuilder<EObject> createDynamicColumnBuilder(final EObject label, final boolean visible) {
        return new DynamicColumnBuilder<EObject>(){

            @Override
            public Map buildHeader(Action base, ETypedElement tElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) {
                Map header = NcoreFactory.eINSTANCE.createMap();
                if (visible) {
                    header.put("visible", visible);
                }
                header.put("key", "__this");
                header.put("label", label);
                return header;
            }

            @Override
            public void buildCell(EObject rowElement, Map row, Action base, ETypedElement tElement, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) {
                EObject renderedValue = EObjectActionBuilder.this.renderValue(base, null, rowElement, context, progressMonitor);
                if (renderedValue != null) {
                    row.put("__this", renderedValue);
                }
            }
        };
    }

    protected java.util.List<DynamicColumnBuilder<? super EObject>> createDynamicColumnBuilders(Collection<ETypedElement> typedElements) {
        return typedElements.stream().map(te -> this.createDynamicColumnBuilder((ETypedElement)te, true)).collect(Collectors.toList());
    }

    protected java.util.List<DynamicColumnBuilder<? super EObject>> createDynamicColumnBuilders(ETypedElement ... typedElements) {
        return this.createDynamicColumnBuilders(Arrays.asList(typedElements));
    }

    @SafeVarargs
    public static <T> org.nasdanika.html.model.html.Tag buildDynamicTable(Collection<? extends T> elements, Action base, ETypedElement typedElement, String configKey, String appId, EObjectActionResolver.Context context, ProgressMonitor progressMonitor, DynamicColumnBuilder<? super T> ... columnBuilders) {
        return EObjectActionBuilder.buildDynamicTable(elements, Arrays.asList(columnBuilders), base, typedElement, configKey, appId, context, progressMonitor);
    }

    public static <T> org.nasdanika.html.model.html.Tag buildDynamicTable(Collection<? extends T> elements, Collection<DynamicColumnBuilder<? super T>> columnBuilders, Action base, ETypedElement typedElement, String configKey, String appId, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) {
        List columns = NcoreFactory.eINSTANCE.createList();
        for (DynamicColumnBuilder<T> dynamicColumnBuilder : columnBuilders) {
            Map column = dynamicColumnBuilder.buildHeader(base, typedElement, context, progressMonitor);
            columns.getValue().add((Object)column);
        }
        List items = NcoreFactory.eINSTANCE.createList();
        for (T element : elements) {
            Map item = NcoreFactory.eINSTANCE.createMap();
            for (DynamicColumnBuilder<T> dynamicColumnBuilder : columnBuilders) {
                dynamicColumnBuilder.buildCell(element, item, base, typedElement, context, progressMonitor);
            }
            items.getValue().add((Object)item);
        }
        org.nasdanika.html.model.html.Tag tag = HtmlFactory.eINSTANCE.createTag();
        tag.setName("nsd-table");
        tag.getAttributes().put((Object)":columns", (Object)columns);
        tag.getAttributes().put((Object)":items", (Object)items);
        if (!Util.isBlank((String)configKey)) {
            tag.getAttributes().put((Object)"config-key", (Object)EObjectActionBuilder.createText(configKey));
        }
        org.nasdanika.html.model.html.Tag appDiv = HtmlFactory.eINSTANCE.createTag();
        appDiv.getContent().add((Object)tag);
        appDiv.setName("div");
        if (Util.isBlank((String)appId)) {
            appId = HTMLFactory.INSTANCE.nextId() + "-vue-app";
        }
        appDiv.getAttributes().put((Object)"id", (Object)EObjectActionBuilder.createText((String)appId));
        org.nasdanika.html.model.html.Tag wrapperDiv = HtmlFactory.eINSTANCE.createTag();
        wrapperDiv.getContent().add((Object)appDiv);
        wrapperDiv.setName("div");
        Script script = HtmlFactory.eINSTANCE.createScript();
        wrapperDiv.getContent().add((Object)script);
        String string = "new Vue({ el: '#" + (String)appId + "' });";
        script.setSource((EObject)EObjectActionBuilder.createText(string));
        return wrapperDiv;
    }

    protected Action createTableAction(ETypedElement typedElement, Collection<ColumnBuilder<? super EObject>> columnBuilders, Action base, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) {
        Action ret = AppFactory.eINSTANCE.createAction();
        this.configureETypedElementLabel(typedElement, (Label)ret, false);
        org.nasdanika.html.model.bootstrap.Table table = EObjectActionBuilder.buildTable((Collection)this.getTypedElementValue(typedElement), columnBuilders, base, typedElement, context, progressMonitor);
        ret.getContent().add((Object)table);
        return ret;
    }

    protected Action createTableAction(ETypedElement typedElement, Action base, EObjectActionResolver.Context context, ProgressMonitor progressMonitor, ETypedElement ... columnElements) {
        return this.createTableAction(typedElement, this.createColumnBuilders(columnElements), base, context, progressMonitor);
    }

    public static Color getSeverityColor(int severity) {
        switch (severity) {
            case 0: {
                return Color.SUCCESS;
            }
            case 8: {
                return Color.SECONDARY;
            }
            case 4: {
                return Color.DANGER;
            }
            case 1: {
                return Color.INFO;
            }
            case 2: {
                return Color.WARNING;
            }
        }
        return Color.PRIMARY;
    }

    protected EObject temporalValue(Action baseAction, ETypedElement typedElement, Temporal temporal, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) {
        Temporal normalized = temporal.normalize();
        Instant instant = normalized.getInstant();
        if (instant != null) {
            return this.renderValue(baseAction, typedElement, instant, context, progressMonitor);
        }
        throw new UnsupportedOperationException("Relative temporals are not supported yet");
    }

    public static interface ContentProvider<T> {
        public java.util.List<EObject> createContent(T var1, Action var2, ETypedElement var3, EObjectActionResolver.Context var4, ProgressMonitor var5);
    }

    protected class EObjectActionResolverAdapter
    extends AdapterImpl
    implements EObjectActionResolver {
        private CollectionCompoundConsumer<EObjectActionResolver.Context> accumulator = new CollectionCompoundConsumer("Resolve consumer accumulator", new Consumer[0]);

        public boolean isAdapterForType(Object type) {
            return type == EObjectActionResolver.class;
        }

        public EObjectActionResolverAdapter() {
            this.accumulator.add((ExecutionParticipant)new Consumer<EObjectActionResolver.Context>(){

                public double size() {
                    return 1.0;
                }

                public String name() {
                    return "Calling resolve()";
                }

                public void execute(EObjectActionResolver.Context registry, ProgressMonitor progressMonitor) {
                    EObjectActionBuilder.this.resolve((Action)EObjectActionResolverAdapter.this.getTarget(), registry, progressMonitor);
                }
            });
        }

        public void add(Consumer<EObjectActionResolver.Context> consumer) {
            this.accumulator.add(consumer);
        }

        public void execute(EObjectActionResolver.Context context, ProgressMonitor progressMonitor) {
            this.accumulator.execute((Object)context, progressMonitor);
            ((Action)this.getTarget()).eAdapters().remove((Object)this);
        }

        public double size() {
            return 1.0;
        }

        public String name() {
            return "Resolving " + EObjectActionBuilder.this.name();
        }
    }
}

