/*
 * Decompiled with CFR 0.152.
 */
package org.nasdanika.html.emf;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.codec.binary.Hex;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.nasdanika.common.BiSupplier;
import org.nasdanika.common.Context;
import org.nasdanika.common.MutableContext;
import org.nasdanika.common.NasdanikaException;
import org.nasdanika.common.ProgressMonitor;
import org.nasdanika.common.PropertyComputer;
import org.nasdanika.common.Status;
import org.nasdanika.common.Util;
import org.nasdanika.drawio.Document;
import org.nasdanika.emf.persistence.TextResourceFactory;
import org.nasdanika.graph.Element;
import org.nasdanika.html.emf.EObjectActionBuilder;
import org.nasdanika.html.emf.EObjectActionResolver;
import org.nasdanika.html.model.app.Action;
import org.nasdanika.html.model.app.Label;
import org.nasdanika.ncore.Documented;
import org.nasdanika.ncore.ModelElement;
import org.nasdanika.ncore.NamedElement;
import org.nasdanika.ncore.util.NcoreUtil;
import org.xml.sax.SAXException;

public class NcoreActionBuilder<T extends EObject>
extends EObjectActionBuilder<T> {
    private static final String TARGET_URI_KEY = "target-uri";
    private static final String SEMANTIC_UUID_KEY = "semantic-uuid";
    private static final String ACTION_URI_KEY = "action-uri";
    private static final String ACTION_UUID_KEY = "action-uuid";

    public NcoreActionBuilder(T target, Context context) {
        super(target, context);
    }

    @Override
    protected Action buildAction(Action action, BiConsumer<EObject, Action> registry, Consumer<org.nasdanika.common.Consumer<EObjectActionResolver.Context>> resolveConsumer, ProgressMonitor progressMonitor) {
        BiSupplier cPath;
        String id;
        Action ret = super.buildAction(action, registry, resolveConsumer, progressMonitor);
        Object semanticElement = this.getTarget();
        List uris = NcoreUtil.getUris(semanticElement);
        String string = id = uris.isEmpty() ? null : ((URI)uris.get(0)).toString();
        if (semanticElement instanceof ModelElement) {
            ModelElement modelElement = (ModelElement)semanticElement;
            ret.setTooltip(modelElement.getDescription());
            if (id == null) {
                id = modelElement.getUuid();
            }
        }
        if (!Util.isBlank((String)id)) {
            try {
                String digest = Hex.encodeHexString((byte[])MessageDigest.getInstance("SHA-256").digest(id.getBytes(StandardCharsets.UTF_8)));
                ret.setId(digest);
            }
            catch (NoSuchAlgorithmException digest) {
                // empty catch block
            }
        }
        if ((cPath = NcoreUtil.containmentPath(semanticElement)) == null || Util.isBlank((String)((String)cPath.getSecond()))) {
            ret.setLocation("${base-uri}index." + this.getHtmlExtension());
        } else {
            ret.setLocation((String)cPath.getSecond() + "/index." + this.getHtmlExtension());
        }
        if (semanticElement instanceof NamedElement) {
            ret.setText(((NamedElement)semanticElement).getName());
        }
        return ret;
    }

    @Override
    protected void resolve(Action action, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) {
        super.resolve(action, context, progressMonitor);
        Object semanticElement = this.getTarget();
        if (semanticElement instanceof Documented) {
            EList documentation = ((Documented)semanticElement).getDocumentation();
            action.getContent().addAll(EcoreUtil.copyAll((Collection)documentation));
        }
        if (semanticElement instanceof ModelElement) {
            for (Map.Entry semanticRepresentationEntry : ((ModelElement)semanticElement).getRepresentations()) {
                String actionRepresentation = this.processRepresentation((String)semanticRepresentationEntry.getValue(), action, context, progressMonitor);
                if (Util.isBlank((String)actionRepresentation)) continue;
                action.getRepresentations().put((Object)((String)semanticRepresentationEntry.getKey()), (Object)actionRepresentation);
            }
        }
    }

    protected String processRepresentation(String representation, Action action, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) {
        URI representationURI = URI.createURI((String)representation);
        if (Document.isDataURI((URI)representationURI)) {
            try {
                Document document = Document.load((URI)representationURI);
                Document processedDocument = this.processDrawioRepresentation(document, action, context, progressMonitor);
                if (processedDocument == null) {
                    return null;
                }
                return processedDocument.toDataURI(Boolean.valueOf(true)).toString();
            }
            catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
                throw new NasdanikaException("Error loading drawio document: " + e, (Throwable)e);
            }
        }
        return representation;
    }

    protected Document processDrawioRepresentation(Document document, Action action, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) {
        document.accept(element -> this.processDrawioElement((Element)element, action, context, progressMonitor));
        return document;
    }

    protected void processDrawioElement(Element element, Action action, EObjectActionResolver.Context context, ProgressMonitor progressMonitor) {
        if (element instanceof org.nasdanika.drawio.ModelElement) {
            org.nasdanika.drawio.ModelElement modelElement = (org.nasdanika.drawio.ModelElement)element;
            String semanticUUID = (String)modelElement.getProperty((Object)SEMANTIC_UUID_KEY);
            if (Util.isBlank((String)semanticUUID)) {
                String targetUriPropertyValue = (String)modelElement.getProperty((Object)TARGET_URI_KEY);
                if (!Util.isBlank((String)targetUriPropertyValue)) {
                    boolean found = false;
                    for (URI tURI : NcoreActionBuilder.resolveURIs(TARGET_URI_KEY, modelElement, NcoreUtil.getUris((EObject)action))) {
                        String uriTargetActionTooltip;
                        Action uriTargetAction;
                        EObject uriTarget = NcoreActionBuilder.findByURI(tURI, this.getTarget());
                        if (uriTarget == null || uriTarget == null || (uriTargetAction = context.getAction(uriTarget)) == null) continue;
                        String uriTargetActionUUID = uriTargetAction.getUuid();
                        if (!Util.isBlank((String)uriTargetActionUUID)) {
                            modelElement.setProperty(ACTION_UUID_KEY, uriTargetActionUUID);
                        }
                        if (Util.isBlank((String)modelElement.getTooltip()) && !Util.isBlank((String)(uriTargetActionTooltip = uriTargetAction.getTooltip()))) {
                            modelElement.setTooltip(uriTargetActionTooltip);
                        }
                        found = true;
                        break;
                    }
                    if (!found) {
                        String message = "Action with URI " + targetUriPropertyValue + " not found";
                        progressMonitor.worked(Status.ERROR, 1.0, message, new Object[]{modelElement});
                    }
                }
            } else {
                Action semanticModelElementAction;
                ModelElement semanticModelElement = NcoreActionBuilder.findByUUID(semanticUUID, this.getTarget());
                if (semanticModelElement != null && (semanticModelElementAction = context.getAction((EObject)semanticModelElement)) != null) {
                    String semanticModelElementDescription;
                    String semanticModelElementActionUUID = semanticModelElementAction.getUuid();
                    if (!Util.isBlank((String)semanticModelElementActionUUID)) {
                        modelElement.setProperty(ACTION_UUID_KEY, semanticModelElementActionUUID);
                    }
                    if (Util.isBlank((String)modelElement.getTooltip()) && !Util.isBlank((String)(semanticModelElementDescription = semanticModelElementAction.getDescription()))) {
                        modelElement.setTooltip(semanticModelElementDescription);
                    }
                }
            }
        }
    }

    private static TreeIterator<? extends Notifier> getAllContents(EObject semanticElement) {
        Resource resource = semanticElement.eResource();
        if (resource == null) {
            return semanticElement.eAllContents();
        }
        ResourceSet resourceSet = resource.getResourceSet();
        if (resourceSet == null) {
            return resource.getAllContents();
        }
        return resourceSet.getAllContents();
    }

    private static ModelElement findByUUID(String uuid, EObject semanticElement) {
        String semanticElementUUID;
        if (Util.isBlank((String)uuid)) {
            return null;
        }
        if (semanticElement instanceof ModelElement && uuid.equals(semanticElementUUID = ((ModelElement)semanticElement).getUuid())) {
            return (ModelElement)semanticElement;
        }
        TreeIterator<Notifier> rscit = NcoreActionBuilder.getAllContents(semanticElement);
        while (rscit.hasNext()) {
            String nextUUID;
            Notifier next = (Notifier)rscit.next();
            if (!(next instanceof ModelElement) || !uuid.equals(nextUUID = ((ModelElement)next).getUuid())) continue;
            return (ModelElement)next;
        }
        return null;
    }

    private static EObject findByURI(URI uri, EObject semanticElement) {
        List semanticURIs = NcoreUtil.getUris((EObject)semanticElement);
        HashSet<URI> uris = new HashSet<URI>();
        uris.add(uri);
        for (URI semanticURI : semanticURIs) {
            if (!uri.isRelative() || semanticURI.isRelative() || !semanticURI.isHierarchical()) continue;
            uris.add(uri.resolve(semanticURI));
        }
        for (URI semanticURI : semanticURIs) {
            for (URI uRI : uris) {
                if (!Objects.equals(semanticURI, uRI)) continue;
                return semanticElement;
            }
        }
        TreeIterator<Notifier> rscit = NcoreActionBuilder.getAllContents(semanticElement);
        while (rscit.hasNext()) {
            String string;
            Notifier next = (Notifier)rscit.next();
            if (!(next instanceof EObject)) continue;
            EObject nextEObject = (EObject)next;
            for (URI nextUri : NcoreUtil.getUris((EObject)nextEObject)) {
                if (nextUri == null) continue;
                for (URI u : uris) {
                    if (!nextUri.equals(u)) continue;
                    return nextEObject;
                }
            }
            if (!(next instanceof ModelElement) || Util.isBlank((String)(string = ((ModelElement)next).getUuid()))) continue;
            URI uuidUri = URI.createURI((String)("uuid:" + string));
            for (URI u : uris) {
                if (!uuidUri.equals(u)) continue;
                return nextEObject;
            }
        }
        return null;
    }

    public static String actionMarker(Action action) {
        List uris;
        EList markers;
        String location;
        StringBuilder actionMarker = new StringBuilder("[Action] ");
        String text = action.getText();
        if (!Util.isBlank((String)text)) {
            actionMarker.append(text);
        }
        if (!Util.isBlank((String)(location = action.getLocation()))) {
            if (!Util.isBlank((String)text)) {
                actionMarker.append(", ");
            }
            actionMarker.append("location=").append(location);
        }
        if (!(markers = action.getMarkers()).isEmpty()) {
            if (!Util.isBlank((String)text)) {
                actionMarker.append(", ");
            }
            actionMarker.append("markers=").append(markers);
        }
        if (!(uris = NcoreUtil.getUris((EObject)action)).isEmpty()) {
            if (!Util.isBlank((String)text)) {
                actionMarker.append(", ");
            }
            actionMarker.append("uris=").append(markers);
        }
        return actionMarker.toString();
    }

    public static Map<String, Object> resolveRepresentationLinks(final Action action, final BiFunction<Label, URI, URI> uriResolver, final BiConsumer<String, String> resolutionErrorConsumer, final ProgressMonitor progressMonitor) {
        final String actionMarker = NcoreActionBuilder.actionMarker(action);
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        for (Map.Entry actionRepresentationEntry : action.getRepresentations()) {
            URI representationURI = URI.createURI((String)((String)actionRepresentationEntry.getValue()));
            if (Document.isDataURI((URI)representationURI)) {
                try {
                    Document document = Document.load((URI)representationURI);
                    document.accept(element -> NcoreActionBuilder.resolveLink(element, action, uriResolver, (modelElement, error) -> resolutionErrorConsumer.accept(modelElement.toString() + " " + modelElement.getMarkers().toString(), (String)error), progressMonitor));
                    ret.put((String)actionRepresentationEntry.getKey(), document);
                    continue;
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    throw new NasdanikaException("Error loading drawio document: " + e, (Throwable)e);
                }
            }
            if (!TextResourceFactory.isDataURI((URI)representationURI)) continue;
            Resource textResource = new TextResourceFactory().createResource(representationURI);
            try {
                textResource.load(null);
            }
            catch (IOException e) {
                throw new NasdanikaException("Error loading text resource from data URI: " + e, (Throwable)e);
            }
            StringBuilder textBuilder = new StringBuilder();
            for (EObject eObj : textResource.getContents()) {
                if (eObj instanceof org.nasdanika.ncore.String) {
                    String text = ((org.nasdanika.ncore.String)eObj).getValue();
                    if (text == null) continue;
                    textBuilder.append(text);
                    continue;
                }
                throw new UnsupportedOperationException("Unsupported contents: " + eObj);
            }
            MutableContext context = Context.EMPTY_CONTEXT.fork();
            PropertyComputer actionUUIDPropertyComputer = new PropertyComputer(){

                public <T> T compute(Context propertyComputerContext, String key, String path, Class<T> type) {
                    if (type == null || type.isAssignableFrom(String.class)) {
                        URI ret = NcoreActionBuilder.resolveActionUUIDLink(path, action, uriResolver, error -> resolutionErrorConsumer.accept(actionMarker, error), progressMonitor);
                        return (T)(ret == null ? null : ret.toString());
                    }
                    return null;
                }
            };
            context.put(ACTION_UUID_KEY, (Object)actionUUIDPropertyComputer);
            PropertyComputer actionURIPropertyComputer = new PropertyComputer(){

                public <T> T compute(Context propertyComputerContext, String key, String path, Class<T> type) {
                    if (type == null || type.isAssignableFrom(String.class)) {
                        URI ret = NcoreActionBuilder.resolveActionURILink(path, action, uriResolver, error -> resolutionErrorConsumer.accept(actionMarker, error), progressMonitor);
                        return (T)(ret == null ? null : ret.toString());
                    }
                    return null;
                }
            };
            context.put(ACTION_URI_KEY, (Object)actionURIPropertyComputer);
            ret.put((String)actionRepresentationEntry.getKey(), context.computingContext().interpolateToString(textBuilder.toString()));
        }
        return ret;
    }

    private static URI resolveActionUUIDLink(String actionUUID, Action action, BiFunction<Label, URI, URI> uriResolver, Consumer<String> propertyResolutionErrorConsumer, ProgressMonitor progressMonitor) {
        if (!Util.isBlank((String)actionUUID)) {
            ModelElement targetAction = NcoreActionBuilder.findByUUID(actionUUID, (EObject)action);
            if (targetAction instanceof Label) {
                URI actionURI = uriResolver.apply((Label)action, null);
                URI targetURI = uriResolver.apply((Label)targetAction, actionURI);
                if (targetURI != null) {
                    return targetURI;
                }
            } else {
                String message = "Unresolved action UUID: " + actionUUID;
                progressMonitor.worked(Status.ERROR, 1.0, message, new Object[]{action});
                if (propertyResolutionErrorConsumer != null) {
                    propertyResolutionErrorConsumer.accept(message);
                }
            }
        }
        return null;
    }

    private static URI resolveActionURILink(String aURI, Action action, BiFunction<Label, URI, URI> uriResolver, Consumer<String> propertyResolutionErrorConsumer, ProgressMonitor progressMonitor) {
        if (!Util.isBlank((String)aURI)) {
            EObject targetAction = NcoreActionBuilder.findByURI(URI.createURI((String)aURI), (EObject)action);
            if (targetAction instanceof Label) {
                URI actionURI = uriResolver.apply((Label)action, null);
                URI targetURI = uriResolver.apply((Label)targetAction, actionURI);
                if (targetURI != null) {
                    return targetURI;
                }
            } else {
                String message = "Unresolved action URI: " + aURI;
                progressMonitor.worked(Status.ERROR, 1.0, message, new Object[]{action});
                if (propertyResolutionErrorConsumer != null) {
                    propertyResolutionErrorConsumer.accept(message);
                }
            }
        }
        return null;
    }

    private static void resolveLink(Element element, Action action, BiFunction<Label, URI, URI> uriResolver, BiConsumer<org.nasdanika.drawio.ModelElement, String> resolutionErrorConsumer, ProgressMonitor progressMonitor) {
        if (element instanceof org.nasdanika.drawio.ModelElement) {
            String actionUriPropertyValue;
            org.nasdanika.drawio.ModelElement modelElement = (org.nasdanika.drawio.ModelElement)element;
            String actionUUID = (String)modelElement.getProperty((Object)ACTION_UUID_KEY);
            if (Util.isBlank((String)modelElement.getLink()) && !Util.isBlank((String)actionUUID)) {
                ModelElement targetAction = NcoreActionBuilder.findByUUID(actionUUID, (EObject)action);
                if (targetAction instanceof Label) {
                    URI actionURI = uriResolver.apply((Label)action, null);
                    URI targetURI = uriResolver.apply((Label)targetAction, actionURI);
                    if (targetURI != null) {
                        String actionTooltip;
                        modelElement.setLink(targetURI.toString());
                        if (Util.isBlank((String)modelElement.getTooltip()) && !Util.isBlank((String)(actionTooltip = ((Label)targetAction).getTooltip()))) {
                            modelElement.setTooltip(actionTooltip);
                        }
                    }
                } else {
                    String message = "Action with UUID " + actionUUID + " not found";
                    progressMonitor.worked(Status.ERROR, 1.0, message, new Object[]{modelElement});
                    if (resolutionErrorConsumer != null) {
                        resolutionErrorConsumer.accept(modelElement, message);
                    }
                }
            }
            if (!Util.isBlank((String)(actionUriPropertyValue = (String)modelElement.getProperty((Object)ACTION_URI_KEY)))) {
                boolean found = false;
                for (URI aURI : NcoreActionBuilder.resolveURIs(ACTION_URI_KEY, modelElement, NcoreUtil.getUris((EObject)action))) {
                    EObject targetAction;
                    if (!Util.isBlank((String)modelElement.getLink()) || aURI == null || !((targetAction = NcoreActionBuilder.findByURI(aURI, (EObject)action)) instanceof Label)) continue;
                    URI actionURI = uriResolver.apply((Label)action, null);
                    URI targetURI = uriResolver.apply((Label)targetAction, actionURI);
                    if (targetURI != null) {
                        String actionTooltip;
                        modelElement.setLink(targetURI.toString());
                        if (Util.isBlank((String)modelElement.getTooltip()) && !Util.isBlank((String)(actionTooltip = ((Label)targetAction).getTooltip()))) {
                            modelElement.setTooltip(actionTooltip);
                        }
                    }
                    found = true;
                    break;
                }
                if (!found) {
                    String message = "Action with URI " + actionUriPropertyValue + " not found";
                    progressMonitor.worked(Status.ERROR, 1.0, message, new Object[]{modelElement});
                    if (resolutionErrorConsumer != null) {
                        resolutionErrorConsumer.accept(modelElement, message);
                    }
                }
            }
        }
    }

    private static Collection<URI> resolveURIs(String propertyName, org.nasdanika.drawio.ModelElement modelElement, Collection<URI> bases) {
        String aURI = (String)modelElement.getProperty((Object)propertyName);
        if (Util.isBlank((String)aURI)) {
            return Collections.emptySet();
        }
        URI actionURI = URI.createURI((String)aURI);
        HashSet<URI> ret = new HashSet<URI>();
        ret.add(actionURI);
        if (actionURI.isRelative()) {
            for (URI actionBaseURI : NcoreActionBuilder.resolveBaseURIs(propertyName, modelElement.getParent(), bases)) {
                if (actionBaseURI == null || actionBaseURI.isRelative() || !actionBaseURI.isHierarchical()) continue;
                ret.add(actionURI.resolve(actionBaseURI));
            }
        }
        return ret;
    }

    private static Collection<URI> resolveBaseURIs(String propertyName, org.nasdanika.drawio.ModelElement modelElement, Collection<URI> bases) {
        if (modelElement == null) {
            return bases;
        }
        String aURI = (String)modelElement.getProperty((Object)propertyName);
        return Util.isBlank((String)aURI) ? NcoreActionBuilder.resolveBaseURIs(propertyName, modelElement.getParent(), bases) : NcoreActionBuilder.resolveURIs(propertyName, modelElement, bases);
    }
}

