/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;

public class BeanPropertyMappingWriter
extends BeanPropertyWriter {
    private BeanPropertyWriter base;
    private SerializedString name;

    public BeanPropertyMappingWriter(BeanPropertyWriter base, String name) {
        this(base, new SerializedString(name));
    }

    public BeanPropertyMappingWriter(BeanPropertyWriter base, SerializedString name) {
        super(base);
        this.base = base;
        this.name = name;
    }

    public void serializeAsField(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
        Class<?> cls;
        PropertySerializerMap m;
        Object value;
        Object object = value = this._accessorMethod == null ? this._field.get(bean) : this._accessorMethod.invoke(bean, new Object[0]);
        if (value == null) {
            if (this._nullSerializer != null) {
                gen.writeFieldName(this.getSerializedName());
                this._nullSerializer.serialize(null, gen, prov);
            }
            return;
        }
        JsonSerializer ser = this._serializer;
        if (ser == null && (ser = (m = this._dynamicSerializers).serializerFor(cls = value.getClass())) == null) {
            ser = this._findAndAddDynamic(m, cls, prov);
        }
        if (this._suppressableValue != null && (MARKER_FOR_EMPTY == this._suppressableValue ? ser.isEmpty(prov, value) : this._suppressableValue.equals(value))) {
            return;
        }
        if (value == bean && this._handleSelfReference(bean, gen, prov, ser)) {
            return;
        }
        gen.writeFieldName(this.getSerializedName());
        if (this._typeSerializer == null) {
            ser.serialize(value, gen, prov);
        } else {
            ser.serializeWithType(value, gen, prov, this._typeSerializer);
        }
    }

    public String getName() {
        if (this.name != null) {
            return this.name.getValue();
        }
        return super.getName();
    }

    public SerializableString getSerializedName() {
        if (this.name != null) {
            return this.name;
        }
        return super.getSerializedName();
    }
}

