/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanPropertyMappingWriter;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializer;
import com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.fasterxml.jackson.databind.ser.impl.BeanAsArraySerializer;
import com.fasterxml.jackson.databind.ser.impl.ObjectIdWriter;
import com.fasterxml.jackson.databind.ser.impl.UnwrappingBeanSerializer;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public class BeanSerializerImpl
extends BeanSerializerBase {
    private static final long serialVersionUID = 5121780229739981922L;

    protected BeanSerializerImpl(BeanSerializerBase src, BeanPropertyWriter[] properties) {
        super(src, properties, src._filteredProps);
    }

    protected BeanSerializerImpl(BeanSerializerBase src, ObjectIdWriter objectIdWriter, Object filterId) {
        super(src, objectIdWriter, filterId);
    }

    protected BeanSerializerImpl(BeanSerializerBase src, Set<String> toIgnore) {
        super(src, toIgnore);
    }

    public JsonSerializer<Object> unwrappingSerializer(NameTransformer unwrapper) {
        return new UnwrappingBeanSerializer((BeanSerializerBase)this, unwrapper);
    }

    public BeanSerializerBase withObjectIdWriter(ObjectIdWriter objectIdWriter) {
        return new BeanSerializerImpl(this, objectIdWriter, this._propertyFilterId);
    }

    public BeanSerializerBase withFilterId(Object filterId) {
        return new BeanSerializerImpl(this, this._objectIdWriter, filterId);
    }

    protected BeanSerializerBase withIgnorals(Set<String> toIgnore) {
        return new BeanSerializerImpl((BeanSerializerBase)this, toIgnore);
    }

    protected BeanSerializerBase asArraySerializer() {
        if (this._objectIdWriter == null && this._anyGetterWriter == null && this._propertyFilterId == null) {
            return new BeanAsArraySerializer((BeanSerializerBase)this);
        }
        return this;
    }

    public final void serialize(Object bean, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (this._objectIdWriter != null) {
            gen.setCurrentValue(bean);
            this._serializeWithObjectId(bean, gen, provider, true);
            return;
        }
        gen.writeStartObject(bean);
        if (this._propertyFilterId != null) {
            this.serializeFieldsFiltered(bean, gen, provider);
        } else {
            this.serializeFields(bean, gen, provider);
        }
        gen.writeEndObject();
    }

    public String toString() {
        return "BeanSerializer for " + this.handledType().getName();
    }

    public static BeanSerializerBase serializedMapping(BeanSerializerBase beanSerializer, Map<String, String> serializedMapping) {
        BeanPropertyWriter[] props = beanSerializer._props;
        BeanPropertyWriter[] usedProps = new BeanPropertyWriter[props.length];
        for (int i = 0; i < props.length; ++i) {
            BeanPropertyWriter prop = props[i];
            String name = prop.getName();
            String serializedName = serializedMapping.get(name);
            usedProps[i] = serializedName != null && serializedName.length() > 0 ? new BeanPropertyMappingWriter(prop, serializedName) : prop;
        }
        BeanSerializerImpl beanSerializerImpl = new BeanSerializerImpl(beanSerializer, usedProps);
        return beanSerializerImpl;
    }

    public static BeanSerializerBase serializedMapping(ObjectMapper objectMapper, Class<?> type, Map<String, String> serializedMapping) throws JsonMappingException {
        JavaType javaType = TypeFactory.defaultInstance().constructType(type);
        SerializerProvider serializerProvider = objectMapper.getSerializerProviderInstance();
        BeanSerializer jsonSerializer = (BeanSerializer)BeanSerializerFactory.instance.createSerializer(serializerProvider, javaType);
        return BeanSerializerImpl.serializedMapping((BeanSerializerBase)jsonSerializer, serializedMapping);
    }

    public static SimpleModule registerModule(ObjectMapper objectMapper, Class<?> type, Map<String, String> serializedMapping) throws JsonMappingException {
        BeanSerializerBase beanSerializerImpl = BeanSerializerImpl.serializedMapping(objectMapper, type, serializedMapping);
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(type, (JsonSerializer)beanSerializerImpl);
        objectMapper.registerModule((Module)simpleModule);
        return simpleModule;
    }
}

