/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.aop;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;

public class AopUtils {
    public static String getLongClassName(JoinPoint jp) {
        String classNameAll = jp.getTarget().getClass().getName();
        return classNameAll;
    }

    public static String getShortClassName(JoinPoint jp) {
        String className = jp.getTarget().getClass().getSimpleName();
        return className;
    }

    public static String getMethodName(JoinPoint jp) {
        String className = jp.getSignature().getName();
        return className;
    }

    public static String getClassNameAndMethodName(JoinPoint jp) {
        String className = AopUtils.getLongClassName(jp);
        String methodName = AopUtils.getMethodName(jp);
        String classAndMethod = className + "." + methodName;
        return classAndMethod;
    }

    public static String getShortClassAndMethodName(JoinPoint jp) {
        String className = AopUtils.getShortClassName(jp);
        String methodName = AopUtils.getMethodName(jp);
        String classAndMethod = className + "." + methodName;
        return classAndMethod;
    }

    public static Method getMethod(JoinPoint jp) {
        Signature signature = jp.getSignature();
        if (signature instanceof MethodSignature) {
            MethodSignature methodSignature = (MethodSignature)signature;
            return methodSignature.getMethod();
        }
        return null;
    }

    public static <T extends Annotation> T getMethodAnnotation(JoinPoint jp, Class<T> annotationClass) {
        Method method = AopUtils.getMethod(jp);
        if (method != null) {
            return method.getAnnotation(annotationClass);
        }
        return null;
    }

    public boolean isMethodAnnotationPresent(JoinPoint jp, Class<? extends Annotation> annotationClass) {
        return AopUtils.getMethodAnnotation(jp, annotationClass) != null;
    }
}

