/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.component.logger;

import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nbone.component.logger.AopMethodParamsProcessor;
import org.nbone.component.logger.LogVoFactory;
import org.nbone.component.logger.LoggerContext;
import org.nbone.component.logger.LoggerStatic;
import org.nbone.component.logger.OperateType;
import org.nbone.component.logger.config.LoggerConfiguration;
import org.nbone.component.logger.util.BizcLogPropsUtil;
import org.nbone.component.logger.util.LoggerUtils;
import org.nbone.component.logger.vo.LogVo;

public abstract class AbstractAopLogProcessor
implements AopMethodParamsProcessor,
LoggerStatic {
    protected Log logger = LogFactory.getLog(this.getClass());
    private static boolean isInited = false;
    private static boolean isLogOut = false;
    protected LoggerContext loggerContext;

    public void process(String fullClassName, String methodName, Object[] args, Throwable throwable) {
        if (!isInited) {
            this.init();
        }
        if (isLogOut) {
            System.out.println("=============================AOP \u62e6\u622a\u5f00\u59cb(aop start)===============================");
        }
        String objectIdKey = fullClassName + ".ID";
        String objectDescKey = fullClassName + ".DESC";
        String cnmn = fullClassName + "." + methodName;
        if (isLogOut) {
            System.out.println("\u62e6\u622a\u65b9\u6cd5:" + cnmn);
        }
        String objectVal = BizcLogPropsUtil.getString(fullClassName);
        String methodVal = BizcLogPropsUtil.getString(cnmn);
        String methodIdKey = cnmn + ".ID";
        String methodOperationTypeKey = cnmn + ".OPERATION_TYPE";
        String methodDescKey = cnmn + ".DESC";
        String objectIdVal = BizcLogPropsUtil.getString(objectIdKey);
        String objectDescVal = BizcLogPropsUtil.getString(objectDescKey);
        String methodIdVal = BizcLogPropsUtil.getString(methodIdKey);
        String methodOperationTypeVal = BizcLogPropsUtil.getString(methodOperationTypeKey);
        String methodDescVal = BizcLogPropsUtil.getString(methodDescKey);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(">>>>>>>>>>>>>" + new StringBuilder(objectIdKey).append("=").append(objectIdVal)));
            this.logger.debug((Object)(">>>>>>>>>>>>>" + new StringBuilder(objectDescKey).append("=").append(objectDescVal)));
            this.logger.debug((Object)(">>>>>>>>>>>>>" + new StringBuilder(methodIdKey).append("=").append(methodIdVal)));
            this.logger.debug((Object)(">>>>>>>>>>>>>" + new StringBuilder(methodOperationTypeKey).append("=").append(methodOperationTypeVal)));
            this.logger.debug((Object)(">>>>>>>>>>>>>" + new StringBuilder(methodDescKey).append("=").append(methodDescVal)));
        }
        LogVo logVo = throwable == null ? LogVoFactory.getDefaultNewLogVO() : LogVoFactory.getOperateFailedNewLogVO();
        if (objectDescVal != null && methodOperationTypeVal != null && methodDescVal != null) {
            Map map = this.loggerContext.getMap("LOGGER_OPERATION_TYPE");
            logVo.setOperateType(OperateType.getOperateTypeByCode(LoggerUtils.getMapKeyByValue(map, methodOperationTypeVal)));
            this.finishCallBack(args, throwable, logVo);
        } else if (objectVal != null && methodVal != null) {
            String tempObjectVal = LoggerUtils.getStandardJSONObject(objectVal);
            String tempMethodVal = LoggerUtils.getStandardJSONObject(methodVal);
            JSONObject objectMap = JSONObject.fromObject((Object)tempObjectVal);
            JSONObject methodMap = JSONObject.fromObject((Object)tempMethodVal);
            objectIdVal = String.valueOf(objectMap.get(ID));
            objectDescVal = String.valueOf(objectMap.get(DESC));
            methodIdVal = String.valueOf(methodMap.get(ID));
            methodOperationTypeVal = String.valueOf(methodMap.get(OPERATION_TYPE));
            methodDescVal = String.valueOf(methodMap.get(DESC));
            Map map = this.loggerContext.getMap("LOGGER_OPERATION_TYPE");
            logVo.setOperateType(OperateType.getOperateTypeByCode(LoggerUtils.getMapKeyByValue(map, methodOperationTypeVal)));
            this.finishCallBack(args, throwable, logVo);
        } else {
            this.logger.warn((Object)new StringBuilder("\u6b64\u65b9\u6cd5\u6ca1\u6709\u914d\u7f6e:[").append(cnmn).append("]."));
        }
        if (isLogOut) {
            System.out.println("=============================AOP \u62e6\u622a\u7ed3\u675f(aop end)===============================");
        }
    }

    public abstract String processException(Throwable var1);

    public abstract void saveLog(LogVo var1);

    public void finishCallBack(Object[] args, Throwable throwable, LogVo logVo) {
        this.process(args, logVo);
        String errMsg = this.processException(throwable);
        logVo = this.setFinalDescription(logVo, errMsg);
        this.saveLog(logVo);
    }

    private LogVo setFinalDescription(LogVo logVo, String errMsg) {
        if (logVo.getOperateResult() == 1) {
            logVo.setDescription(logVo.getDescription() + ";\u64cd\u4f5c\u6210\u529f.");
        } else {
            logVo.setDescription(logVo.getDescription() + ";\u64cd\u4f5c\u5931\u8d25,\u539f\u56e0: " + errMsg);
        }
        return logVo;
    }

    public void init() {
        LoggerConfiguration configuration = new LoggerConfiguration();
        configuration.init();
        this.loggerContext = LoggerContext.getCurrentLoggerContext();
        isInited = true;
        isLogOut = Boolean.valueOf(this.loggerContext.getString("LOGGER_IS_LOG_OUT"));
    }
}

