/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.component.logger;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.nbone.aop.AopUtils;
import org.nbone.component.logger.AbstractAopLogProcessor;
import org.nbone.component.logger.IAdvice;

public class BizcAopLogAdvice
implements IAdvice {
    private Log logger = LogFactory.getLog(BizcAopLogAdvice.class);
    private AbstractAopLogProcessor aopLogProcessor;

    public AbstractAopLogProcessor getAopLogProcessor() {
        return this.aopLogProcessor;
    }

    public void setAopLogProcessor(AbstractAopLogProcessor aopLogProcessor) {
        this.aopLogProcessor = aopLogProcessor;
    }

    @Override
    public void before(JoinPoint jp) {
        this.process(jp, null);
    }

    @Override
    public void after(JoinPoint jp) {
        this.process(jp, null);
    }

    @Override
    public void afterReturning(JoinPoint jp) {
        this.process(jp, null);
    }

    @Override
    public void afterThrowing(JoinPoint jp, Throwable throwable) {
        this.process(jp, throwable);
    }

    public void process(JoinPoint jp, Throwable throwable) {
        try {
            Object[] args = jp.getArgs();
            String fullClassName = AopUtils.getLongClassName(jp);
            String methodName = AopUtils.getMethodName(jp);
            String cnmn = AopUtils.getClassNameAndMethodName(jp);
            this.aopLogProcessor.process(fullClassName, methodName, args, throwable);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private Map<String, String> proessMethodParams(Object[] objArgs, String[] configPlace) {
        HashMap<String, String> configPlaceMap = new HashMap<String, String>();
        int n = 0;
        Object[] objectArray = objArgs;
        int n2 = objectArray.length;
        if (n < n2) {
            Object o = objectArray[n];
            if (o instanceof List) {
                List list = (List)o;
                Map map = (Map)list.get(0);
            } else if (!(o instanceof String)) {
                // empty if block
            }
        }
        return configPlaceMap;
    }
}

