/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.component.logger.config;

import java.util.Map;
import java.util.Properties;
import net.sf.json.JSONObject;
import org.nbone.component.logger.LoggerContext;
import org.nbone.component.logger.LoggerStatic;
import org.nbone.component.logger.util.BizcLogPropsUtil;
import org.nbone.component.logger.util.LogPropsUtils;
import org.nbone.component.logger.util.LoggerUtils;

public class LoggerConfiguration
implements LoggerStatic {
    private Properties props;
    private LoggerContext context = LoggerContext.getCurrentLoggerContext();
    private String loggerOperationType;

    public void init() {
        String operationType = this.getInitConfigParameter("LOGGER_OPERATION_TYPE", "0:QUERY,1:CREATE,2:DELETE,3:UPDATE");
        this.setLoggerOperationType(operationType);
        this.context.put("LOGGER_OPERATION_TYPE", this.formatOperationType(operationType));
        String isLogOut = this.getInitConfigParameter("LOGGER_IS_LOG_OUT", "false");
        this.context.put("LOGGER_IS_LOG_OUT", isLogOut);
    }

    public Map formatOperationType(String loggerOperationType) {
        String json = LoggerUtils.getStandardJSONObject(loggerOperationType);
        return JSONObject.fromObject((Object)json);
    }

    private String getInitConfigParameter(String key, String defValue) {
        String value = LogPropsUtils.getString(key, defValue);
        String newValue = BizcLogPropsUtil.getString(key);
        if (newValue == null) {
            newValue = value;
        }
        return newValue;
    }

    public String getLoggerOperationType() {
        return this.loggerOperationType;
    }

    public void setLoggerOperationType(String loggerOperationType) {
        this.loggerOperationType = loggerOperationType;
    }
}

