/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.core.exception;

import com.fasterxml.jackson.annotation.JsonAlias;

public class ExceptionInfo {
    public static final String MESSAGE_TEMPLATE = "{\"code\": %s,\"message\": \"%s\"}";
    private String requestId;
    private String logId;
    private Object timestamp;
    private int code;
    private String message;
    private String exception;
    @JsonAlias(value={"status"})
    private int statusCode = 400;
    @JsonAlias(value={"path"})
    private String url;

    public ExceptionInfo() {
    }

    public ExceptionInfo(int code, String msg) {
        this.code = code;
        this.message = msg;
    }

    public ExceptionInfo(int statusCode, int code, String message) {
        this.code = code;
        this.message = message;
        this.statusCode = statusCode;
    }

    public ExceptionInfo(int code, String message, int statusCode) {
        this.code = code;
        this.message = message;
        this.statusCode = statusCode;
    }

    public ExceptionInfo(int code, String message, Exception ex) {
        this(code, message, null, ex.getClass().getSimpleName());
    }

    public ExceptionInfo(int code, String message, String url) {
        this(code, message, url, null);
    }

    public ExceptionInfo(int code, String message, String url, String exceptionName) {
        this.code = code;
        this.message = message;
        this.url = url;
        this.exception = exceptionName;
    }

    public ExceptionInfo(int code, String message, int statusCode, String exceptionName) {
        this.code = code;
        this.message = message;
        this.statusCode = statusCode;
        this.exception = exceptionName;
    }

    public ExceptionInfo(int code, String message, int statusCode, String url, String exceptionName) {
        this.code = code;
        this.message = message;
        this.statusCode = statusCode;
        this.url = url;
        this.exception = exceptionName;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public ExceptionInfo requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String getLogId() {
        return this.logId;
    }

    public void setLogId(String logId) {
        this.logId = logId;
    }

    public ExceptionInfo logId(String logId) {
        this.logId = logId;
        return this;
    }

    public Object getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Object timestamp) {
        this.timestamp = timestamp;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getException() {
        return this.exception;
    }

    public void setException(String exception) {
        this.exception = exception;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

