/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.core.exception;

import java.io.Serializable;

public class ModuleSystemException
extends RuntimeException {
    private String moduleName;
    private Serializable code;
    private Serializable requestId;

    public ModuleSystemException(String moduleName, String message, Throwable cause) {
        super(message, cause);
        this.moduleName = moduleName;
    }

    public ModuleSystemException(String moduleName, String message) {
        super(message);
        this.moduleName = moduleName;
    }

    public ModuleSystemException(String moduleName, Throwable cause) {
        super(cause);
        this.moduleName = moduleName;
    }

    public ModuleSystemException(Throwable cause) {
        super(cause);
    }

    @Override
    public String getMessage() {
        if (this.moduleName != null) {
            return this.moduleName + ": " + super.getMessage();
        }
        return this.getClass().getSimpleName() + ": " + super.getMessage();
    }

    public ModuleSystemException code(Serializable code) {
        this.code = code;
        return this;
    }

    public ModuleSystemException requestId(Serializable requestId) {
        this.requestId = requestId;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("code=").append(this.code);
        sb.append(", message=").append(super.getMessage());
        sb.append(", moduleName=").append(this.moduleName);
        if (this.requestId != null) {
            sb.append(", requestId=").append(this.requestId);
        }
        sb.append('}');
        return sb.toString();
    }
}

