/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.core.exception;

import java.io.Serializable;

public class SubSystemException
extends RuntimeException {
    private String systemName;
    private Serializable code;
    private Serializable requestId;

    public SubSystemException(String systemName, String message, Throwable cause) {
        super(message, cause);
        this.systemName = systemName;
    }

    public SubSystemException(String systemName, String message) {
        super(message);
        this.systemName = systemName;
    }

    public SubSystemException(String systemName, Throwable cause) {
        super(cause);
        this.systemName = systemName;
    }

    public SubSystemException(Throwable cause) {
        super(cause);
    }

    @Override
    public String getMessage() {
        if (this.systemName != null) {
            return this.systemName + ": " + super.getMessage();
        }
        return this.getClass().getSimpleName() + ": " + super.getMessage();
    }

    public SubSystemException code(Serializable code) {
        this.code = code;
        return this;
    }

    public SubSystemException requestId(Serializable requestId) {
        this.requestId = requestId;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("{");
        sb.append("code=").append(this.code);
        sb.append(", message=").append(super.getMessage());
        sb.append(", systemName=").append(this.systemName);
        if (this.requestId != null) {
            sb.append(", requestId=").append(this.requestId);
        }
        sb.append('}');
        return sb.toString();
    }
}

