/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.core.task;

import org.nbone.core.task.TaskExecutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTaskExecutable
implements TaskExecutable {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractTaskExecutable.class);

    @Override
    public void run() {
        try {
            this.execute();
        }
        catch (Exception e) {
            logger.error(this.getTaskName() + " -task execute exception.thinking", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Exception {
        if (!this.isAvailable()) {
            logger.warn(this.getTaskName() + " -task is not available.thinking");
            return;
        }
        this.preExecute();
        try {
            long start = System.currentTimeMillis();
            this.doExecute();
            long end = System.currentTimeMillis();
            long xx = end - start;
            logger.debug(this.getTaskName() + " -task execute time = " + xx);
        }
        catch (Exception e) {
            this.afterThrowing(e);
        }
        finally {
            this.afterFinally();
        }
        this.afterExecute();
    }

    protected abstract void preExecute();

    protected abstract void afterExecute();

    protected abstract void afterThrowing(Exception var1);

    protected void afterFinally() {
    }

    protected void doExecute() throws Exception {
        this.doExecuteInternal();
    }

    protected abstract void doExecuteInternal() throws Exception;
}

