/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.core.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nbone.lang.IEnum;
import org.springframework.util.ClassUtils;

public class EnumUtils {
    private static Log logger = LogFactory.getLog(EnumUtils.class);

    public static <T> IEnum<T>[] getEnums(Class<?> clazz) {
        if (IEnum.class.isAssignableFrom(clazz)) {
            ?[] enumConstants = clazz.getEnumConstants();
            return (IEnum[])enumConstants;
        }
        return null;
    }

    public static <T> IEnum<T>[] getEnums(String className) {
        try {
            Class clazz = ClassUtils.forName((String)className, (ClassLoader)ClassUtils.getDefaultClassLoader());
            return EnumUtils.getEnums(clazz);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
            return null;
        }
    }

    public static <T> T getEnum(Class<T> clazz, String code) {
        IEnum[] enumConstants;
        if (!IEnum.class.isAssignableFrom(clazz)) {
            return null;
        }
        for (IEnum enumConstant : enumConstants = (IEnum[])clazz.getEnumConstants()) {
            if (!((String)enumConstant.getCode()).equalsIgnoreCase(code)) continue;
            return (T)enumConstant;
        }
        return null;
    }

    public static <T> T getEnum(Class<T> clazz, Number code) {
        IEnum[] enumConstants;
        if (!IEnum.class.isAssignableFrom(clazz)) {
            return null;
        }
        for (IEnum enumConstant : enumConstants = (IEnum[])clazz.getEnumConstants()) {
            if (!((Number)enumConstant.getCode()).equals(code)) continue;
            return (T)enumConstant;
        }
        return null;
    }

    public static <T> T getEnum(String clazzName, String code) {
        try {
            Class clazz = ClassUtils.forName((String)clazzName, (ClassLoader)ClassUtils.getDefaultClassLoader());
            return EnumUtils.getEnum(clazz, code);
        }
        catch (ClassNotFoundException | LinkageError e) {
            logger.error((Object)e);
            return null;
        }
    }
}

