/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import org.springframework.util.ObjectUtils;

public class GsonExclusionStrategy
implements ExclusionStrategy {
    public boolean shouldSkipField(FieldAttributes f) {
        JsonIgnoreProperties ignoreProperties = f.getDeclaringClass().getAnnotation(JsonIgnoreProperties.class);
        if (ignoreProperties != null) {
            Object[] names = ignoreProperties.value();
            if (ObjectUtils.isEmpty((Object[])names)) {
                return false;
            }
            for (Object name : names) {
                if (!f.getName().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean shouldSkipClass(Class<?> clazz) {
        return clazz.isAnnotationPresent(JsonIgnoreType.class);
    }
}

