/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.nbone.util.lang.ToStringUtils;
import org.springframework.beans.BeanUtils;

public abstract class BaseObject {
    public static String INPUT_PARAMETERS = "The method of input parameters";
    public static String OUTPUT_PARAMETERS = "The method of output parameters";

    protected <E> E newInstance(Class<E> clazz) {
        Object instance = BeanUtils.instantiate(clazz);
        return (E)instance;
    }

    protected <E> E copyProperties(Object source, Class<E> targetClass) {
        E target = this.newInstance(targetClass);
        BeanUtils.copyProperties((Object)source, target);
        return target;
    }

    protected <E> List<E> copyProperties(Object[] sources, Class<E> targetClass) {
        ArrayList<E> targetList = new ArrayList<E>(sources.length);
        for (Object source : sources) {
            E targetObject = this.copyProperties(source, targetClass);
            targetList.add(targetObject);
        }
        return targetList;
    }

    protected <E> List<E> copyProperties(Collection<?> sources, Class<E> targetClass) {
        ArrayList<E> targetList = new ArrayList<E>(sources.size());
        for (Object source : sources) {
            E targetObject = this.copyProperties(source, targetClass);
            targetList.add(targetObject);
        }
        return targetList;
    }

    public boolean state(int number) {
        return number > 0;
    }

    public boolean state(long number) {
        return number > 0L;
    }

    public boolean state(Number number) {
        if (number == null) {
            return false;
        }
        return number.intValue() > 0;
    }

    public String toString() {
        return ToStringUtils.toString(this);
    }

    public static void main(String[] args) {
        BaseObject ss = new BaseObject(){};
        ArrayList sources = new ArrayList();
        ss.copyProperties(sources, BaseObject.class);
    }
}

