/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.message.mail.service.impl;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nbone.message.IUseCallback;
import org.nbone.message.mail.MailAuthenticator;
import org.nbone.message.mail.exception.MailException;
import org.nbone.message.mail.service.IMailService;
import org.nbone.message.mail.service.impl.MailUseCallback;
import org.nbone.message.mail.vo.EmailVo;
import org.nbone.message.mail.vo.MailServerVo;

public class MailServiceImpl
implements IMailService {
    private static final Log logger = LogFactory.getLog(MailServiceImpl.class);
    private static final String TIP = "\u90ae\u4ef6\u53d1\u9001-";
    public static final String Content_Type_Plain = "plain";
    public static final String Content_Type_Html = "html";
    public static final String Charset_UTF_8 = "UTF-8";

    @Override
    public void sendMailServiceList(List<EmailVo> emailVoList) throws MailException {
        try {
            if (emailVoList == null) {
                logger.error((Object)new StringBuilder().append(TIP).append("MAIL_\u4f20\u5165\u53c2\u6570\u4e3a\u7a7a"));
                return;
            }
            for (EmailVo emailVo : emailVoList) {
                this.sendMailService(emailVo);
            }
        }
        catch (Exception e) {
            logger.error((Object)new StringBuilder().append(TIP).append("MAIL_\u904d\u5386\u90ae\u4ef6\u51fa\u73b0\u5f02\u5e38"), (Throwable)e);
        }
    }

    @Override
    public boolean sendMailService(EmailVo emailVo) throws MailException {
        return this.sendMailService(emailVo, new MailUseCallback());
    }

    @Override
    public boolean sendMailService(EmailVo emailVo, IUseCallback<EmailVo, Object> useCallback) throws MailException {
        boolean isflag = false;
        boolean result = false;
        if (useCallback != null) {
            isflag = useCallback.preHandle(emailVo);
        }
        if (isflag) {
            result = this.sendMail(emailVo);
        }
        if (useCallback != null) {
            useCallback.postHandle(emailVo, result);
        }
        return result;
    }

    public final boolean sendMail(EmailVo emailVo) throws MailException {
        return this.doSendMail(emailVo, null);
    }

    public final boolean sendHtmlMail(EmailVo emailVo) throws MailException {
        return this.doSendMail(emailVo, Content_Type_Html);
    }

    protected boolean doSendMail(EmailVo emailVo, String contentType) throws MailException {
        boolean result = true;
        MimeMessage msg = this.createMessage(emailVo);
        String subject = emailVo.getSubject();
        String content = emailVo.getContent();
        Set<String> attachFiles = emailVo.getAttachFiles();
        try {
            if (attachFiles == null || attachFiles.size() == 0) {
                if (contentType == null || contentType == "" || Content_Type_Plain.equals(contentType)) {
                    msg.setText(content, Charset_UTF_8);
                } else if (Content_Type_Html.equals(contentType)) {
                    msg.setContent((Object)content, "text/html;charset=UTF-8");
                } else {
                    msg.setText(content);
                }
            } else if (contentType == null || contentType == "" || Content_Type_Plain.equals(contentType)) {
                MimeBodyPart bp = new MimeBodyPart();
                bp.setText(content);
                MimeMultipart mm = new MimeMultipart();
                mm.addBodyPart((BodyPart)bp);
                mm = this.addAttachFile((Multipart)mm, attachFiles);
                msg.setContent((Multipart)mm);
            } else if (Content_Type_Html.equals(contentType)) {
                MimeBodyPart bp = new MimeBodyPart();
                bp.setContent((Object)content, "text/html;charset=UTF-8");
                MimeMultipart mm = new MimeMultipart();
                mm.addBodyPart((BodyPart)bp);
                mm = this.addAttachFile((Multipart)mm, attachFiles);
                msg.setContent((Multipart)mm);
            } else {
                msg.setText(content);
            }
            msg.setSubject(subject, Charset_UTF_8);
            msg.setSentDate(new Date());
            msg.saveChanges();
            Transport.send((Message)msg);
        }
        catch (Exception e) {
            result = false;
            throw new MailException(e);
        }
        return result;
    }

    private MimeMessage createMessage(EmailVo emailVo) throws MailException {
        MailServerVo mailServerVo = emailVo.getMailServerVo();
        if (mailServerVo == null) {
            throw new MailException(" please conifg mail server info [MailServerVo].");
        }
        List<String> toAddressList = emailVo.getToAddressList();
        List<String> ccAddressList = emailVo.getCcAddressList();
        List<String> bccAddressList = emailVo.getBccAddressList();
        String fromAddress = mailServerVo.getFromAddress();
        String mailServerHost = mailServerVo.getServerHost();
        int mailServerPort = mailServerVo.getServerPort();
        String userName = mailServerVo.getUserName();
        String password = mailServerVo.getPassword();
        String nick = mailServerVo.getNickname();
        Properties props = mailServerVo.getProperties();
        MailAuthenticator authenticator = null;
        if (mailServerVo.isValidate()) {
            authenticator = new MailAuthenticator(mailServerVo.getUserName(), mailServerVo.getPassword());
        }
        Session session = Session.getDefaultInstance((Properties)props, authenticator);
        MimeMessage msg = new MimeMessage(session);
        try {
            InternetAddress[] toAddress = this.parse(toAddressList);
            InternetAddress[] ccAddress = this.parse(ccAddressList);
            InternetAddress[] bccAddress = this.parse(bccAddressList);
            msg.setFrom((Address)new InternetAddress(fromAddress, nick));
            msg.setRecipients(Message.RecipientType.TO, (Address[])toAddress);
            msg.setRecipients(Message.RecipientType.CC, (Address[])ccAddress);
            msg.setRecipients(Message.RecipientType.BCC, (Address[])bccAddress);
        }
        catch (Exception e) {
            throw new MailException(e);
        }
        return msg;
    }

    private Multipart addAttachFile(Multipart mp, Set<String> attachFiles) throws MailException, IOException, MessagingException {
        if (mp == null) {
            throw new MailException("bean Multipart is null .");
        }
        if (attachFiles == null || attachFiles.size() == 0) {
            return mp;
        }
        for (String fileName : attachFiles) {
            MimeBodyPart mbp_file = new MimeBodyPart();
            mbp_file.attachFile(fileName);
            mp.addBodyPart((BodyPart)mbp_file);
            String encode = MimeUtility.encodeText((String)mbp_file.getFileName());
            mbp_file.setFileName(encode);
        }
        return mp;
    }

    private Multipart addAttachFile(Set<String> attachFiles) throws MailException, IOException, MessagingException {
        MimeMultipart mp = new MimeMultipart();
        this.addAttachFile((Multipart)mp, attachFiles);
        return mp;
    }

    private InternetAddress[] parse(List<String> addressList) throws AddressException {
        if (addressList == null || addressList.size() == 0) {
            return null;
        }
        int size = addressList.size();
        InternetAddress[] address = new InternetAddress[size];
        for (int i = 0; i < size; ++i) {
            address[i] = new InternetAddress(addressList.get(i));
        }
        return address;
    }
}

