/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.message.mail.util;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nbone.message.mail.exception.MailException;
import org.nbone.message.mail.service.IMailService;
import org.nbone.message.mail.service.impl.MailServiceImpl;
import org.nbone.message.mail.vo.EmailVo;
import org.nbone.message.mail.vo.MailServerVo;
import org.nbone.message.util.CheckUtils;
import org.springframework.util.StringUtils;

public class EmailUtils {
    public static Log logger = LogFactory.getLog(EmailUtils.class);
    private static boolean isInitiate;
    private static IMailService mailService;

    public static boolean send(String subject, String content, Object emailUserList, MailServerVo mailServerVo, boolean isFilter) throws MailException {
        if (mailServerVo == null) {
            throw new MailException(" please conifg mail server info [MailServerVo].");
        }
        List<String> emailList = null;
        if (emailUserList instanceof List) {
            emailList = (List<String>)emailUserList;
        } else if (emailUserList instanceof String) {
            String[] ss = StringUtils.commaDelimitedListToStringArray((String)((String)emailUserList));
            emailList = Arrays.asList(ss);
        } else {
            throw new IllegalArgumentException("\u90ae\u4ef6\u7528\u6237\u5217\u8868\u53c2\u6570\u6709\u8bef. \u539f\u53c2\u6570\uff1a" + emailUserList);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u90ae\u4ef6\u5185\u5bb9: >>>>>>>>>>>>>>>>>>" + content));
            logger.debug((Object)("\u90ae\u4ef6\u7528\u6237\u5217\u8868: >>>>>>>>>>>>>>>>" + emailUserList));
        }
        List<String> sendableemailList = emailList;
        if (isFilter) {
            List<String> usableEmailList = CheckUtils.filterEmail(emailList);
            sendableemailList = usableEmailList;
        }
        EmailVo emailVo = new EmailVo(sendableemailList, subject, content);
        emailVo.setMailServerVo(mailServerVo);
        boolean succeed = false;
        try {
            succeed = mailService.sendMailService(emailVo);
        }
        catch (MailException e) {
            logger.error((Object)"\u90ae\u4ef6\u53d1\u9001\u5931\u8d25.", (Throwable)e);
        }
        return succeed;
    }

    public static boolean send(String subject, String content, Object emailUserList, MailServerVo mailServerVo) throws MailException {
        return EmailUtils.send(subject, content, emailUserList, mailServerVo, true);
    }

    public static void asyncSend(final String subject, final String content, final Object emailUserList, final MailServerVo mailServerVo) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    EmailUtils.send(subject, content, emailUserList, mailServerVo);
                }
                catch (MailException e) {
                    logger.error((Object)"\u90ae\u4ef6\u53d1\u9001\u5931\u8d25.", (Throwable)e);
                }
            }
        };
        thread.start();
    }

    @Deprecated
    public static void initiateMailServerVo(MailServerVo mailServer) {
    }

    @Deprecated
    public static void reinitiateMailServerVo(MailServerVo mailServer) {
    }

    static {
        mailService = new MailServiceImpl();
    }
}

