/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.message.sms.util;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nbone.message.sms.exception.SmsException;
import org.nbone.message.sms.service.impl.MasServiceImpl;
import org.nbone.message.sms.vo.SmsVo;
import org.nbone.message.util.CheckUtils;
import org.springframework.util.StringUtils;

public class SmsUtils {
    public static Log logger = LogFactory.getLog(SmsUtils.class);

    public static void send(String content, Object phoneList, boolean isFilter) {
        List<String> mobileList = null;
        if (phoneList instanceof List) {
            mobileList = (List<String>)phoneList;
        } else if (phoneList instanceof String) {
            String[] ss = StringUtils.commaDelimitedListToStringArray((String)((String)phoneList));
            mobileList = Arrays.asList(ss);
        } else {
            throw new IllegalArgumentException("\u624b\u673a\u53f7\u5217\u8868\u53c2\u6570\u6709\u8bef. \u539f\u53c2\u6570\uff1a" + phoneList);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u77ed\u4fe1\u5185\u5bb9: >>>>>>>>>>>>>>>>>>" + content));
            logger.debug((Object)("\u624b\u673a\u53f7\u5217\u8868: >>>>>>>>>>>>>>>>" + phoneList));
        }
        List<String> userNumberList = mobileList;
        if (isFilter) {
            List<String> usableMobileList = CheckUtils.filterMobilePhone(mobileList);
            userNumberList = usableMobileList;
        }
        SmsVo smsVo = new SmsVo(userNumberList, content);
        try {
            new MasServiceImpl().submitSmsReq(smsVo);
        }
        catch (SmsException e) {
            logger.error((Object)"\u77ed\u4fe1\u53d1\u9001\u5931\u8d25.", (Throwable)e);
        }
    }

    public static void send(String content, Object phoneList) {
        SmsUtils.send(content, phoneList, true);
    }

    public static void asyncSend(final String content, final Object phoneList) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                SmsUtils.send(content, phoneList);
            }
        };
        thread.start();
    }
}

