/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.mvc.domain;

public class GroupQuery {
    private String groupBy;
    private String orderBy;
    private String queryColumn;
    private Class<?> mapClass;

    public static GroupQuery build() {
        return new GroupQuery();
    }

    public GroupQuery groupBy(String columnName) {
        this.groupBy = columnName;
        return this;
    }

    public GroupQuery orderBy(String column) {
        this.orderBy = column;
        return this;
    }

    public GroupQuery mapClass(Class<?> mapClass) {
        this.mapClass = mapClass;
        return this;
    }

    public GroupQuery queryColumn(String queryColumn) {
        this.queryColumn = queryColumn;
        return this;
    }

    public String groupBy() {
        return this.groupBy;
    }

    public String orderBy() {
        return this.orderBy;
    }

    public String queryColumn() {
        return this.queryColumn;
    }

    public String getQueryColumnBySql() {
        if (this.queryColumn == null) {
            throw new IllegalArgumentException("queryColumn columnName not is null.");
        }
        if (this.queryColumn.indexOf(this.groupBy) == -1) {
            return this.queryColumn + "," + this.groupBy;
        }
        return this.queryColumn;
    }

    public String getGroupBySql() {
        if (this.groupBy == null) {
            throw new IllegalArgumentException("groupBy columnName not is null.");
        }
        return " group by " + this.groupBy;
    }

    public String getOrderBySql() {
        if (this.orderBy == null) {
            return null;
        }
        return " order by " + this.orderBy;
    }

    public Class<?> getMapClass() {
        return this.mapClass;
    }
}

