/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.mvc.rest;

public class ApiResponse<T> {
    private static int SUCCESS_CODE = 0;
    private static int ERROR_CODE = 1;
    private static int initialized = 0;
    private static final String SUCCESS_MESSAGE = "success";
    private static final String ERROR_MESSAGE = "failed";
    private String requestId;
    private String logId;
    private Object timestamp;
    private int code;
    private String status;
    private String path;
    private String message;
    private T data;

    public ApiResponse() {
    }

    public ApiResponse(int code, String msg) {
        this.code = code;
        this.message = msg;
    }

    public ApiResponse(int code, String msg, T data) {
        this.code = code;
        this.message = msg;
        this.data = data;
    }

    public ApiResponse(int code, String status, String message) {
        this.code = code;
        this.status = status;
        this.message = message;
    }

    public ApiResponse(int code, String status, String message, T data) {
        this.code = code;
        this.status = status;
        this.message = message;
        this.data = data;
    }

    public static final void initialize(int successCode, int errorCode) {
        if (initialized >= 1) {
            throw new IllegalStateException("success and error code initialized");
        }
        SUCCESS_CODE = successCode;
        ERROR_CODE = errorCode;
        ++initialized;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public ApiResponse<T> requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public Object getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Object timestamp) {
        this.timestamp = timestamp;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getLogId() {
        return this.logId;
    }

    public void setLogId(String logId) {
        this.logId = logId;
    }

    public ApiResponse<T> logId(String logId) {
        this.logId = logId;
        return this;
    }

    public static <T> ApiResponse<T> error(String msg) {
        return ApiResponse.error(ERROR_CODE, msg != null ? msg : ERROR_MESSAGE);
    }

    public static <T> ApiResponse<T> error(int code, String msg) {
        return new ApiResponse<T>(code, msg != null ? msg : ERROR_MESSAGE);
    }

    public static <T> ApiResponse<T> failed(String msg) {
        return ApiResponse.error(msg);
    }

    public static <T> ApiResponse<T> failed(int code, String msg) {
        return ApiResponse.error(code, msg);
    }

    public static <T> ApiResponse<T> success() {
        return new ApiResponse<T>(SUCCESS_CODE, SUCCESS_MESSAGE);
    }

    public static <T> ApiResponse<T> success(String msg) {
        return new ApiResponse<T>(SUCCESS_CODE, msg);
    }

    public static <T> ApiResponse<T> success(T data) {
        return new ApiResponse<T>(SUCCESS_CODE, SUCCESS_MESSAGE, data);
    }

    public static <T> ApiResponse<T> response(int code, String msg, T data) {
        return new ApiResponse<T>(code, msg, data);
    }
}

