/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.mx.datacontrols.datapage;

import java.io.Serializable;
import java.util.List;

public class PagerModel<T>
implements Serializable {
    private static final long serialVersionUID = 864785535881496596L;
    private int pageNow;
    private int pageSize = 20;
    private long pageCount;
    private long totalPages;
    private long total;
    private List<T> rows;
    private int firstResult = 0;
    private boolean hasNextPage;
    private boolean hasPreviousPage;
    private boolean autoCount = true;

    public PagerModel() {
    }

    public PagerModel(int pageSize) {
        this.pageSize = pageSize;
    }

    public PagerModel(int pageNow, int pageSize) {
        this.pageNow = pageNow;
        this.pageSize = pageSize;
    }

    public PagerModel(List<T> rows) {
        this.rows = rows;
        this.total = rows == null ? 0L : (long)rows.size();
    }

    public PagerModel(long total, List<T> rows) {
        this.total = total;
        this.rows = rows;
    }

    public PagerModel(int total, List<T> rows) {
        this.total = total;
        this.rows = rows;
    }

    public PagerModel(long total, List<T> rows, int pageNow, int pageSize) {
        this.total = total;
        this.rows = rows;
        this.pageNow = pageNow;
        this.pageSize = pageSize;
    }

    public PagerModel(int total, List<T> rows, int pageNow, int pageSize) {
        this((long)total, rows, pageNow, pageSize);
    }

    public int getPageNow() {
        return this.pageNow;
    }

    public void setPageNow(int pageNow) {
        if (pageNow < 1) {
            pageNow = 1;
        }
        this.pageNow = pageNow;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public long getPageCount() {
        this.pageCount = this.getTotalPages();
        return this.pageCount;
    }

    public void setPageCount(int pageCount) {
        this.pageCount = pageCount;
    }

    public long getTotalPages() {
        if (this.total < 0L) {
            return -1L;
        }
        long count = this.total / (long)this.pageSize;
        this.totalPages = this.total % (long)this.pageSize == 0L ? count : count + 1L;
        return this.totalPages;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public List<T> getRows() {
        return this.rows;
    }

    public void setRows(List<T> rows) {
        this.rows = rows;
    }

    public int getFirstResult() {
        this.firstResult = (this.pageNow - 1) * this.pageSize;
        return this.firstResult;
    }

    public void setFirstResult(int firstResult) {
        this.firstResult = firstResult;
    }

    public boolean isHasNextPage() {
        this.hasNextPage = (long)this.getPageNow() < this.getTotalPages();
        return this.hasNextPage;
    }

    public boolean isHasPreviousPage() {
        this.hasPreviousPage = this.getPageNow() > 1;
        return this.hasPreviousPage;
    }

    public int getNextPage() {
        if (this.isHasNextPage()) {
            return this.pageNow + 1;
        }
        return this.pageNow;
    }

    public int getPrePage() {
        if (this.isHasPreviousPage()) {
            return this.pageNow - 1;
        }
        return this.pageNow;
    }

    public boolean isAutoCount() {
        return this.autoCount;
    }

    public void setAutoCount(boolean autoCount) {
        this.autoCount = autoCount;
    }
}

