/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.mx.datacontrols.datatree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class JsonTreeNode
implements Serializable {
    protected static final long serialVersionUID = 1L;
    protected String id;
    protected String text;
    protected String icon;
    protected String iconCls;
    protected boolean leaf;
    protected String href;
    protected String hrefTarget;
    protected Object checked;
    protected boolean disabled;
    protected String isPop;
    protected String isLog;
    protected String busiCode;
    protected String isInit;
    protected String type = "";
    protected String url;
    protected String systemId;
    protected String content1;
    protected String content2;
    protected String content3;
    protected int print;
    protected String parent;

    public JsonTreeNode() {
    }

    public JsonTreeNode(String id, String text, String parent) {
        this.id = id;
        this.text = text;
        this.parent = parent;
        this.print = 0;
    }

    public static String getJsonNodeString(Map m, String id, String text, boolean leaf) {
        JsonTreeNode treeNode = new JsonTreeNode();
        treeNode.setId(m.get(id).toString());
        treeNode.setText(m.get(text).toString());
        treeNode.setLeaf(leaf);
        JSONObject jsonObject = JSONObject.fromObject((Object)treeNode);
        return jsonObject.toString();
    }

    public static String getJsonNodeArray(Map m, String[] ids, String[] texts, boolean leaf) {
        JsonTreeNode treeNode = new JsonTreeNode();
        if (ids != null && ids.length > 0) {
            StringBuffer idStr = new StringBuffer();
            for (int i = 0; i < ids.length; ++i) {
                if (i < ids.length - 1) {
                    idStr.append(m.get(ids[i]).toString()).append(",");
                    continue;
                }
                idStr.append(m.get(ids[i]).toString());
            }
            treeNode.setId(idStr.toString());
        }
        if (texts != null && texts.length > 0) {
            StringBuffer textStr = new StringBuffer();
            for (int j = 0; j < texts.length; ++j) {
                if (j < texts.length - 1) {
                    textStr.append("(").append(m.get(texts[j]).toString()).append(")");
                    continue;
                }
                textStr.append(m.get(texts[j]).toString());
            }
            treeNode.setText(textStr.toString());
        }
        treeNode.setLeaf(leaf);
        JSONObject jsonObject = JSONObject.fromObject((Object)treeNode);
        return jsonObject.toString();
    }

    public static String getJsonNodeString(Map m, String id, String text, boolean leaf, String icon) {
        JsonTreeNode treeNode = new JsonTreeNode();
        treeNode.setId(m.get(id).toString());
        treeNode.setText(m.get(text).toString());
        treeNode.setLeaf(leaf);
        treeNode.setIcon(icon);
        JSONObject jsonObject = JSONObject.fromObject((Object)treeNode);
        return jsonObject.toString();
    }

    public static String getJsonNodeString(List<Map> list, String id, String text, boolean leaf) {
        ArrayList<JsonTreeNode> nodeList = new ArrayList<JsonTreeNode>();
        for (int i = 0; i < list.size(); ++i) {
            JsonTreeNode treeNode = new JsonTreeNode();
            treeNode.setId(list.get(i).get(id).toString());
            treeNode.setText(list.get(i).get(text).toString());
            treeNode.setLeaf(leaf);
            nodeList.add(treeNode);
        }
        JSONArray jsonArray = JSONArray.fromObject(nodeList);
        return jsonArray.toString();
    }

    public static String getJsonNodeString(List<Map> list, String id, String text, boolean leaf, String icon) {
        ArrayList<JsonTreeNode> nodeList = new ArrayList<JsonTreeNode>();
        for (int i = 0; i < list.size(); ++i) {
            JsonTreeNode treeNode = new JsonTreeNode();
            treeNode.setId(list.get(i).get(id).toString());
            treeNode.setText(list.get(i).get(text).toString());
            treeNode.setLeaf(leaf);
            treeNode.setIcon(icon);
            nodeList.add(treeNode);
        }
        JSONArray jsonArray = JSONArray.fromObject(nodeList);
        return jsonArray.toString();
    }

    public static String getJsonNodeString(List<Map> list, String id, String text) {
        ArrayList<JsonTreeNode> nodeList = new ArrayList<JsonTreeNode>();
        for (int i = 0; i < list.size(); ++i) {
            JsonTreeNode treeNode = new JsonTreeNode();
            treeNode.setId(list.get(i).get(id).toString());
            treeNode.setText(list.get(i).get(text).toString());
            nodeList.add(treeNode);
        }
        JSONArray jsonArray = JSONArray.fromObject(nodeList);
        return jsonArray.toString();
    }

    public static String getJsonNodeString(boolean checked, List<Map> list, String id, String text) {
        ArrayList<JsonTreeNode> nodeList = new ArrayList<JsonTreeNode>();
        for (int i = 0; i < list.size(); ++i) {
            JsonTreeNode treeNode = new JsonTreeNode();
            treeNode.setId(list.get(i).get(id).toString());
            treeNode.setText(list.get(i).get(text).toString());
            treeNode.setChecked(checked);
            nodeList.add(treeNode);
        }
        JSONArray jsonArray = JSONArray.fromObject(nodeList);
        return jsonArray.toString();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getIconCls() {
        return this.iconCls;
    }

    public void setIconCls(String iconCls) {
        this.iconCls = iconCls;
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    public void setLeaf(boolean leaf) {
        this.leaf = leaf;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public String getHrefTarget() {
        return this.hrefTarget;
    }

    public void setHrefTarget(String hrefTarget) {
        this.hrefTarget = hrefTarget;
    }

    public Object getChecked() {
        return this.checked;
    }

    public void setChecked(Object checked) {
        this.checked = checked;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getBusiCode() {
        return this.busiCode;
    }

    public void setBusiCode(String busiCode) {
        this.busiCode = busiCode;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public String getIsPop() {
        return this.isPop;
    }

    public void setIsPop(String isPop) {
        this.isPop = isPop;
    }

    public String getIsInit() {
        return this.isInit;
    }

    public void setIsInit(String isInit) {
        this.isInit = isInit;
    }

    public String getIsLog() {
        return this.isLog;
    }

    public void setIsLog(String isLog) {
        this.isLog = isLog;
    }

    public String getContent1() {
        return this.content1;
    }

    public void setContent1(String content1) {
        this.content1 = content1;
    }

    public String getContent2() {
        return this.content2;
    }

    public void setContent2(String content2) {
        this.content2 = content2;
    }

    public String getContent3() {
        return this.content3;
    }

    public void setContent3(String content3) {
        this.content3 = content3;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public int getPrint() {
        return this.print;
    }

    public void setPrint(int print) {
        this.print = print;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }
}

