/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.mx.datacontrols.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nbone.mx.datacontrols.Node;

public abstract class Graph<R>
implements Serializable {
    private static final long serialVersionUID = 7939302796946853658L;
    private Set<Node> nodes;
    private List<R> relationEdges;

    public Graph() {
    }

    public Graph(Set<Node> nodes) {
        this.nodes = nodes;
    }

    public Graph(Set<Node> nodes, List<R> relationEdges) {
        this.nodes = nodes;
        this.relationEdges = relationEdges;
    }

    public Set<Node> getNodes() {
        return this.nodes;
    }

    public void setNodes(Set<Node> nodes) {
        this.nodes = nodes;
    }

    public List<R> getRelationEdges() {
        return this.relationEdges;
    }

    public void setRelationEdges(List<R> relationEdges) {
        this.relationEdges = relationEdges;
    }

    public Graph<R> addNode(Node node) {
        if (this.nodes == null) {
            this.nodes = new HashSet<Node>();
        }
        this.nodes.add(node);
        return this;
    }

    public Graph<R> addRelationEdge(R relationEdge) {
        if (this.relationEdges == null) {
            this.relationEdges = new ArrayList<R>();
        }
        this.relationEdges.add(relationEdge);
        return this;
    }

    public void setNodes(Collection<Node> nodes) {
        this.nodes = new HashSet<Node>(nodes);
    }

    public void setNodes(Map<?, Node> nodesMap) {
        this.nodes = new HashSet<Node>(nodesMap.values());
    }

    public boolean checkCircle() {
        return false;
    }
}

