/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.mx.datacontrols.graph;

import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nbone.mx.datacontrols.Node;
import org.nbone.mx.datacontrols.graph.Graph;
import org.nbone.mx.datacontrols.graph.GraphEdgeModel;
import org.nbone.mx.datacontrols.graph.IdDirectedGraph;
import org.nbone.mx.datacontrols.graph.exception.GraphCircleReferenceException;
import org.nbone.util.graph.CycleDetector;
import org.nbone.util.json.jackson.JsonUtils;

public class GraphModel
extends Graph<GraphEdgeModel> {
    private static final long serialVersionUID = -8929053959689145682L;
    private Map<String, Node> mapNode;

    public GraphModel() {
    }

    public GraphModel(Map<String, Node> mapNode) {
        this(mapNode, null);
    }

    public GraphModel(Map<String, Node> mapNode, List<GraphEdgeModel> relationEdges) {
        this.mapNode = mapNode;
        super.setNodes(mapNode.values());
        super.setRelationEdges(relationEdges);
    }

    public Map<String, Node> getMapNode() {
        return this.mapNode;
    }

    public void setMapNode(Map<String, Node> mapNode) {
        this.mapNode = mapNode;
    }

    @Override
    public boolean checkCircle() {
        return super.checkCircle();
    }

    public static boolean checkCircleAndUpdate(Graph<GraphEdgeModel> graph) {
        boolean check = false;
        List<String> cnodes = GraphModel.checkCircle(graph);
        Set<Node> allNode = graph.getNodes();
        if (cnodes != null && cnodes.size() > 0) {
            check = true;
            block0: for (String nodeId : cnodes) {
                for (Node node : allNode) {
                    if (!nodeId.equals(node.getId())) continue;
                    node.setFlag(true);
                    continue block0;
                }
            }
        }
        return check;
    }

    public static List<String> checkCircle(Graph<GraphEdgeModel> graph) {
        IdDirectedGraph directedGraph = new IdDirectedGraph(graph);
        CycleDetector<String> circle = new CycleDetector<String>(directedGraph);
        circle.containsCycle();
        return circle.getVerticesInCycles();
    }

    public static Node checkCircle(Node rootNode, List<GraphEdgeModel> edges, Node nextNode) throws GraphCircleReferenceException {
        if (rootNode == null || rootNode.getId() == null) {
            return null;
        }
        Node result = null;
        String rootId = rootNode.getId();
        Node useNode = null;
        useNode = nextNode == null ? rootNode : nextNode;
        ArrayList<Node> nextNodes = new ArrayList<Node>();
        for (GraphEdgeModel graphEdgeModel : edges) {
            if (!useNode.getId().equals(graphEdgeModel.getFrom().getId())) continue;
            Node to = graphEdgeModel.getTo();
            nextNodes.add(to);
        }
        for (Node node : nextNodes) {
            if (rootId.equals(node.getId())) {
                throw new GraphCircleReferenceException("Graph \u5b58\u5728\u5faa\u73af\u5f15\u7528.", new GraphEdgeModel(nextNode, rootNode));
            }
            result = node;
            System.out.println(useNode.getId() + ":" + useNode.getName() + "---------------->" + node.getId() + ":" + node.getName());
            Node next = GraphModel.checkCircle(rootNode, edges, node);
            if (next != null) continue;
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        Node rootNode = new Node("0", "root");
        Node node1 = new Node("1", "node1");
        Node node2 = new Node("2", "node2");
        Node node3 = new Node("3", "node3");
        Node node4 = new Node("4", "node4");
        GraphEdgeModel edge1 = new GraphEdgeModel(rootNode, node1);
        GraphEdgeModel edge2 = new GraphEdgeModel(rootNode, node2);
        GraphEdgeModel edge3 = new GraphEdgeModel(node1, node3);
        GraphEdgeModel edge4 = new GraphEdgeModel(node3, node4);
        GraphEdgeModel edge5 = new GraphEdgeModel(node2, node3);
        GraphEdgeModel edge6 = new GraphEdgeModel(node4, node3);
        ArrayList<GraphEdgeModel> list = new ArrayList<GraphEdgeModel>();
        list.add(edge1);
        list.add(edge2);
        list.add(edge3);
        list.add(edge4);
        list.add(edge5);
        list.add(edge6);
        MutableGraph graph1 = GraphBuilder.directed().build();
        graph1.addNode((Object)rootNode);
        graph1.addNode((Object)node1);
        graph1.addNode((Object)node2);
        graph1.addNode((Object)node3);
        graph1.addNode((Object)node4);
        graph1.putEdge((Object)rootNode, (Object)node1);
        graph1.putEdge((Object)rootNode, (Object)node2);
        System.out.println(JsonUtils.pojoToJson(graph1));
        for (int i = 0; i < 5; ++i) {
            try {
                GraphModel graph = new GraphModel();
                graph.addNode(rootNode);
                graph.addNode(node1);
                graph.addNode(node2);
                graph.addNode(node3);
                graph.addNode(node4);
                graph.setRelationEdges(list);
                List<String> cycNodes = GraphModel.checkCircle(graph);
                System.out.println(cycNodes);
            }
            catch (GraphCircleReferenceException e) {
                System.out.println(e.getMessage());
                System.out.println(e.getErrObject().getFrom().getId() + "-------err-------->" + e.getErrObject().getTo().getId());
            }
            System.out.println("---------------");
        }
    }
}

