/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.mx.datacontrols.support;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.util.WebUtils;

public class PaginationSupport
implements Serializable {
    private static final long serialVersionUID = -4113165474296861224L;
    public static final int DEFAULT_PAGE_SIZE = 20;
    private int pageSize;
    private int pageNumber;
    private Long start;
    private Long end;
    protected boolean autoCount = true;
    protected String orderBy;
    protected String order;
    protected Object expression;
    private Map<String, Object> params = null;
    protected List<?> rows = Collections.emptyList();
    protected long total = -1L;

    public PaginationSupport() {
    }

    public PaginationSupport(HttpServletRequest request) {
        String pageNo = WebUtils.findParameterValue((ServletRequest)request, (String)"page");
        String pageSize = WebUtils.findParameterValue((ServletRequest)request, (String)"rows");
        this.pageNumber = pageNo == null ? 1 : Integer.parseInt(pageNo);
        this.pageSize = pageSize == null ? 20 : Integer.parseInt(pageSize);
    }

    public PaginationSupport(int pageSize, int pageNumber) {
        this.pageSize = pageSize;
        this.pageNumber = pageNumber;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
        if (pageNumber < 1) {
            this.pageNumber = 1;
        }
    }

    public PaginationSupport pageNo(int pageNumber) {
        this.setPageNumber(pageNumber);
        return this;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
        if (pageSize < 1) {
            this.pageSize = 10;
        }
    }

    public PaginationSupport pageSize(int thePageSize) {
        this.setPageSize(thePageSize);
        return this;
    }

    public boolean isAutoCount() {
        return this.autoCount;
    }

    public void setAutoCount(boolean autoCount) {
        this.autoCount = autoCount;
    }

    public PaginationSupport autoCount(boolean theAutoCount) {
        this.setAutoCount(theAutoCount);
        return this;
    }

    public Long getStart() {
        return this.start;
    }

    public List<?> getRows() {
        return this.rows;
    }

    public void setRows(List<?> rows) {
        this.rows = rows;
    }

    public void setStart(Long start) {
        this.start = start;
    }

    public Long getEnd() {
        return this.end;
    }

    public void setEnd(Long end) {
        this.end = end;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public Object getExpression() {
        return this.expression;
    }

    public void setExpression(Object expression) {
        this.expression = expression;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public void calc() {
        if (this.getPageSize() == 0) {
            this.setPageSize(10);
        }
        if (this.getPageNumber() <= 0) {
            this.setPageNumber(1);
        }
        long start = (this.getPageNumber() - 1) * this.getPageSize();
        long end = this.getPageNumber() * this.getPageSize();
        this.setStart(start);
        this.setEnd(end);
    }
}

