/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.mx.datacontrols.support;

import java.io.Serializable;

public class ResultWrapper
implements Serializable {
    private static final long serialVersionUID = -6185220705468269585L;
    private boolean successful;
    private Object resultValue;
    private String resultHint;
    private int errCode;
    private String message;
    private boolean debug;
    private Throwable cause;
    private String operationFlag;

    public ResultWrapper() {
    }

    public ResultWrapper(boolean isSuccess) {
        this(isSuccess, null, "");
    }

    public ResultWrapper(boolean isSuccess, Object data, String resultHint) {
        this(isSuccess, data, 1, resultHint);
        this.message = resultHint;
        if (isSuccess) {
            this.setErrCode(1);
        }
    }

    public ResultWrapper(boolean isSuccess, Object data, int errCode, String message) {
        this.successful = isSuccess;
        this.resultValue = data;
        this.errCode = errCode;
        this.message = message;
        if (isSuccess) {
            this.setErrCode(1);
        }
    }

    public static ResultWrapper successResultWraped(Object data, String message) {
        return new ResultWrapper(true, data, message);
    }

    public static ResultWrapper successResultWraped(Object data) {
        return new ResultWrapper(true, data, "");
    }

    public static ResultWrapper successResultWraped(String message) {
        return new ResultWrapper(true, null, message);
    }

    public static ResultWrapper successResultWraped() {
        return new ResultWrapper(true, null, "");
    }

    public static ResultWrapper failedResultWraped(String message) {
        return ResultWrapper.failedResultWraped(message, 0, message);
    }

    public static ResultWrapper failedResultWraped(int errCode, String message) {
        return ResultWrapper.failedResultWraped(message, errCode, message);
    }

    public static ResultWrapper failedResultWraped(String resultHint, int errCode, String message) {
        return new ResultWrapper(false, null, errCode, message);
    }

    public static <T> T processResultValue(Object resultValue, Class<T> clazz) {
        return (T)resultValue;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public void setSuccessful(boolean successful) {
        this.successful = successful;
    }

    public int getErrCode() {
        return this.errCode;
    }

    public void setErrCode(int errCode) {
        this.errCode = errCode;
    }

    public Object getResultValue() {
        return this.resultValue;
    }

    public void setResultValue(Object resultValue) {
        this.resultValue = resultValue;
    }

    public <T> T getResultValue(Class<T> targetClass) {
        return (T)this.resultValue;
    }

    public String getResultHint() {
        return this.resultHint;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public ResultWrapper setCause(Throwable cause) {
        if (this.debug) {
            this.cause = cause;
        }
        return this;
    }

    public String getOperationFlag() {
        return this.operationFlag;
    }

    public ResultWrapper setOperationFlag(String operationFlag) {
        this.operationFlag = operationFlag;
        return this;
    }
}

