/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.persistence.enums;

public enum QueryType {
    EQ("="),
    NE("!="),
    GT(">"),
    GTE(">="),
    LT("<"),
    LTE("<="),
    IN("IN"),
    NOT_IN("NOT IN"),
    BETWEEN("BETWEEN"),
    NOT_BETWEEN("NOT BETWEEN"),
    LIKE("LIKE", "%", "%"),
    LEFT_LIKE("LIKE", "%", ""),
    RIGHT_LIKE("LIKE", "", "%"),
    IS_NULL("IS NULL"),
    IS_NOT_NULL("IS NOT NULL"),
    EQ_FORCE("=", true),
    NE_FORCE("!=", true);

    private final String operation;
    private String valuePrefix;
    private String valueSuffix;
    private Boolean isForce;

    private QueryType(String operation) {
        this.operation = operation;
    }

    private QueryType(String operation, String valuePrefix, String valueSuffix) {
        this.operation = operation;
        this.valuePrefix = valuePrefix;
        this.valueSuffix = valueSuffix;
    }

    private QueryType(String operation, String valuePrefix, String valueSuffix, Boolean isForce) {
        this.operation = operation;
        this.valuePrefix = valuePrefix;
        this.valueSuffix = valueSuffix;
        this.isForce = isForce;
    }

    private QueryType(String operation, Boolean isForce) {
        this.operation = operation;
        this.isForce = isForce;
    }

    public String getOperation() {
        return this.operation;
    }

    public String getValuePrefix() {
        return this.valuePrefix;
    }

    public void setValuePrefix(String valuePrefix) {
        this.valuePrefix = valuePrefix;
    }

    public String getValueSuffix() {
        return this.valueSuffix;
    }

    public void setValueSuffix(String valueSuffix) {
        this.valueSuffix = valueSuffix;
    }

    public Boolean getForce() {
        return this.isForce;
    }

    public void setForce(Boolean force) {
        this.isForce = force;
    }

    public static QueryType of(String operationType) {
        if (operationType == null) {
            return null;
        }
        for (QueryType value : QueryType.values()) {
            if (!value.getOperation().equalsIgnoreCase(operationType)) continue;
            return value;
        }
        return null;
    }

    static {
        QueryType[] QueryTypes = new QueryType[QueryType.values().length];
        QueryType[] queryTypeArray = QueryType.values();
        int n = queryTypeArray.length;
        for (int i = 0; i < n; ++i) {
            QueryType value;
            QueryTypes[value.ordinal()] = value = queryTypeArray[i];
        }
    }
}

