/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.persistence.sharding;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.nbone.persistence.sharding.ShardingInfo;
import org.nbone.persistence.sharding.strategy.ShardingStrategy;
import org.springframework.beans.BeanUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class ShardingEntityInfo
implements Serializable {
    private static final long serialVersionUID = 6975055638838323118L;
    private String logicName;
    private String[] joinName;
    private String shardingName;
    private int dbTotal = 1;
    private int tableTotal = 1;
    private ShardingStrategy shardingStrategy;
    private String delimiter = "_";

    public ShardingEntityInfo(String logicName, String[] joinName, String shardingName) {
        this.logicName = logicName;
        this.joinName = joinName;
        this.shardingName = shardingName;
    }

    public ShardingEntityInfo(String logicName, String[] joinName, String shardingName, String delimiter) {
        this.logicName = logicName;
        this.joinName = joinName;
        this.shardingName = shardingName;
        this.delimiter = delimiter;
    }

    public String getTableName(Object object) {
        String tableName = this.logicName;
        if (!ObjectUtils.isEmpty((Object[])this.joinName)) {
            for (String propertyName : this.joinName) {
                PropertyDescriptor descriptor = BeanUtils.getPropertyDescriptor(object.getClass(), (String)propertyName);
                Object fieldValue = ReflectionUtils.invokeMethod((Method)descriptor.getReadMethod(), (Object)object);
                Assert.notNull((Object)fieldValue, (String)("class " + object.getClass() + " property " + propertyName + " must not be null."));
                tableName = tableName + this.delimiter + fieldValue;
            }
        }
        if (StringUtils.hasLength((String)this.shardingName)) {
            PropertyDescriptor descriptor = BeanUtils.getPropertyDescriptor(object.getClass(), (String)this.shardingName);
            Object fieldValue = ReflectionUtils.invokeMethod((Method)descriptor.getReadMethod(), (Object)object);
            Assert.notNull((Object)fieldValue, (String)("class " + object.getClass() + " property " + this.shardingName + " must not be null."));
            ShardingInfo shardingInfo = this.shardingStrategy.sharding(null, fieldValue, this.dbTotal, this.tableTotal);
            tableName = tableName + this.delimiter + shardingInfo.getTableKey();
        }
        return tableName;
    }

    public String getLogicName() {
        return this.logicName;
    }

    public void setLogicName(String logicName) {
        this.logicName = logicName;
    }

    public String[] getJoinName() {
        return this.joinName;
    }

    public void setJoinName(String[] joinName) {
        this.joinName = joinName;
    }

    public int getDbTotal() {
        return this.dbTotal;
    }

    public void setDbTotal(int dbTotal) {
        this.dbTotal = dbTotal;
    }

    public int getTableTotal() {
        return this.tableTotal;
    }

    public void setTableTotal(int tableTotal) {
        this.tableTotal = tableTotal;
    }

    public ShardingStrategy getShardingStrategy() {
        return this.shardingStrategy;
    }

    public void setShardingStrategy(ShardingStrategy shardingStrategy) {
        this.shardingStrategy = shardingStrategy;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }
}

