/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.persistence.sharding.strategy;

import org.nbone.persistence.sharding.ShardingContext;
import org.nbone.persistence.sharding.ShardingInfo;
import org.nbone.persistence.sharding.strategy.ShardingStrategy;

public class HashShardingStrategy
implements ShardingStrategy {
    @Override
    public <V> ShardingInfo sharding(ShardingContext shardingContext, V shardingValue, int dbTotal, int tableTotal) {
        if (shardingValue == null) {
            throw new IllegalArgumentException("invalid shardingColumnValue:" + shardingValue);
        }
        if (dbTotal <= 0) {
            throw new IllegalArgumentException("invalid dbTotal:" + dbTotal);
        }
        if (tableTotal <= 0) {
            throw new IllegalArgumentException("invalid tableTotal:" + tableTotal);
        }
        if (tableTotal < dbTotal) {
            throw new IllegalArgumentException("tableTotal[" + tableTotal + "] can't less than dbTotal[" + dbTotal + "]");
        }
        long hash = 0L;
        Class<?> shardingClass = shardingValue.getClass();
        if (Long.class.isAssignableFrom(shardingClass) || Long.TYPE.isAssignableFrom(shardingClass)) {
            hash = (Long)shardingValue;
        } else if (Integer.class.isAssignableFrom(shardingClass) || Integer.TYPE.isAssignableFrom(shardingClass)) {
            hash = ((Integer)shardingValue).intValue();
        } else {
            hash = shardingValue.toString().hashCode();
            if (hash < 0L) {
                hash = Math.abs(hash);
            }
        }
        int tableNo = (int)(hash % (long)tableTotal);
        int dbNo = tableNo / (tableTotal / dbTotal);
        String tableKey = String.format("%04d", tableNo);
        String dbKey = String.format("%d", dbNo);
        return new ShardingInfo(dbKey, tableKey);
    }
}

