/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nbone.constants.DateConstant;

public class DateFPUtils
implements DateConstant {
    private static Log logger = LogFactory.getLog(DateFPUtils.class);
    protected static SimpleDateFormat globalFormat = new SimpleDateFormat();

    public static Date parseDateByLongString(String longtimeStr) {
        if (StringUtils.isBlank((CharSequence)longtimeStr)) {
            return null;
        }
        try {
            long longtime = Long.valueOf(longtimeStr);
            return new Date(longtime);
        }
        catch (NumberFormatException e2) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)e2);
            }
            return null;
        }
    }

    public static Date parseDate(String strDateTime, String[] formats) {
        if (StringUtils.isBlank((CharSequence)strDateTime)) {
            return null;
        }
        try {
            Date parseDate = DateUtils.parseDate((String)strDateTime, (String[])formats);
            return parseDate;
        }
        catch (ParseException e) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)e);
            }
            return DateFPUtils.parseDateByLongString(strDateTime);
        }
    }

    public static Date parseDateMultiplePattern(String strDateTime) {
        return DateFPUtils.parseDate(strDateTime, DEFAULT_FORMATS);
    }

    public static Date parseDate(String strDateTime) {
        return DateFPUtils.parseDate(strDateTime, new String[]{"yyyy-MM-dd"});
    }

    public static Date parseFullDate(String strDateTime) {
        return DateFPUtils.parseDate(strDateTime, new String[]{"yyyy-MM-dd HH:mm:ss"});
    }

    public static Date parseDate(String strDateTime, String pattern) {
        return DateFPUtils.parseDate(strDateTime, new String[]{pattern});
    }

    public static Timestamp parseTimestamp(String strDateTime, String pattern) {
        return DateFPUtils.parseTimestamp(strDateTime, new String[]{pattern});
    }

    public static Timestamp parseTimestamp(String strDateTime, String[] patterns) {
        Date parseDate = DateFPUtils.parseDate(strDateTime, patterns);
        return new Timestamp(parseDate.getTime());
    }

    public static String formatDate(Date date) {
        if (date == null) {
            return null;
        }
        return DateFPUtils.formatDate(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String formatDate(Date date, String pattern) {
        if (pattern == null || "".equals(pattern.trim())) {
            pattern = "yyyy-MM-dd HH:mm:ss";
        }
        return DateFormatUtils.format((Date)date, (String)pattern);
    }

    public static String formatDate(Date date, String pattern, TimeZone timezone, Locale locale) {
        return DateFormatUtils.format((Date)date, (String)pattern, (TimeZone)timezone, (Locale)locale);
    }

    public static Date parseDate(String strDateTime, String[] formats, Locale locale, boolean lenient) {
        int count = 0;
        SimpleDateFormat dateFormat = null;
        int length = formats.length;
        for (int i = 0; i < length; ++i) {
            if (dateFormat == null) {
                dateFormat = new SimpleDateFormat(formats[i], locale);
            } else {
                dateFormat.applyPattern(formats[i]);
            }
            dateFormat.setLenient(lenient);
            try {
                String temp = strDateTime.toLowerCase();
                Date parseDate = dateFormat.parse(temp);
                return parseDate;
            }
            catch (ParseException localParseException) {
                ++count;
                continue;
            }
        }
        if (count == length) {
            StringBuilder stringBuilder = new StringBuilder("[" + strDateTime + "]");
            stringBuilder.append(" not match of date format [");
            for (int i = 0; i < length; ++i) {
                stringBuilder.append(formats[i] + ",");
            }
            stringBuilder.append("]");
            logger.warn((Object)stringBuilder);
        }
        return DateFPUtils.parseDateByLongString(strDateTime);
    }

    public static final String formatDateToJidu(Date date) {
        if (date == null) {
            return "";
        }
        String nowDate = DateFPUtils.formatDate(date, "yyyy-MM-dd");
        String months = nowDate.substring(5, 7);
        String jidu = "";
        if (months.equals("01") || months.equals("02") || months.equals("03")) {
            jidu = "1";
        } else if (months.equals("04") || months.equals("05") || months.equals("06")) {
            jidu = "2";
        } else if (months.equals("07") || months.equals("08") || months.equals("09")) {
            jidu = "3";
        } else if (months.equals("10") || months.equals("11") || months.equals("12")) {
            jidu = "4";
        }
        return jidu;
    }

    public static final String formatDateToNiandu(Date date) {
        String nowDate = DateFPUtils.formatDate(date, "yyyy-MM-dd");
        return nowDate.substring(0, 4);
    }

    @Deprecated
    public static Date parseDate1(String value) {
        block11: {
            if (value == null || value.equals("")) {
                return null;
            }
            SimpleDateFormat df = null;
            int ymdLength = value.split("-").length;
            int hmsLength = value.split(":").length;
            if (ymdLength == 2 && hmsLength == 1) {
                df = new SimpleDateFormat("yyyy-MM");
            } else if (ymdLength == 3 && hmsLength == 1) {
                df = new SimpleDateFormat("yyyy-MM-dd");
            } else if (ymdLength == 3 && hmsLength == 2) {
                df = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            } else if (ymdLength == 3 && hmsLength == 3) {
                df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            }
            try {
                if (df != null) {
                    return df.parse(value);
                }
            }
            catch (ParseException e) {
                if (!logger.isErrorEnabled()) break block11;
                logger.error((Object)e.getMessage());
            }
        }
        return null;
    }
}

