/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.time.DateUtils;
import org.nbone.constants.DateConstant;
import org.nbone.util.DateFPUtils;
import org.springframework.util.Assert;

public class DateUtil
extends DateFPUtils
implements DateConstant {
    public static Timestamp toTimestamp(Date date) {
        return new Timestamp(date.getTime());
    }

    public static boolean isSameDay(Date date1, Date date2) {
        return DateUtils.isSameDay((Date)date1, (Date)date2);
    }

    public static boolean isSameTime(Date date1, Date date2) {
        return DateUtils.isSameInstant((Date)date1, (Date)date2);
    }

    public static Date getDate(int year, int month, int day) {
        Assert.isTrue((month > 0 && month < 13 ? 1 : 0) != 0, (String)"month must range[0,12]");
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, DateUtil.convertRealMonthToCalendarMonth(month), day, 0, 0, 0);
        return calendar.getTime();
    }

    public static Date getDateTime(int year, int month, int day, int hour, int minute, int second) {
        Assert.isTrue((month > 0 && month <= 12 ? 1 : 0) != 0, (String)"month must range[0,12]");
        Assert.isTrue((hour >= 0 && hour <= 23 ? 1 : 0) != 0, (String)"hour must range[0,23]");
        Assert.isTrue((minute >= 0 && minute <= 60 ? 1 : 0) != 0, (String)"minute must range[0,60]");
        Assert.isTrue((second >= 0 && second <= 60 ? 1 : 0) != 0, (String)"second must range[0,60]");
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, DateUtil.convertRealMonthToCalendarMonth(month), day, hour, minute, second);
        return calendar.getTime();
    }

    public static boolean isEndOfTheMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int maxDay = calendar.getActualMaximum(5);
        return calendar.get(5) == maxDay;
    }

    public static boolean isEndOfTheYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return 11 == calendar.get(2) && 31 == calendar.get(5);
    }

    public static int getLastDayOfTheMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.getActualMaximum(5);
    }

    public static boolean isStartBeforeEndDate(Date startDate, Date endDate) {
        Assert.notNull((Object)startDate, (String)"StartDate must not be null");
        Assert.notNull((Object)endDate, (String)"EndDate must not be null");
        return DateUtil.resetTime(startDate).compareTo(DateUtil.resetTime(endDate)) < 0;
    }

    public static boolean isStartBeforeEndTime(Date startTime, Date endTime) {
        Assert.notNull((Object)startTime, (String)"StartTime must not be null");
        Assert.notNull((Object)endTime, (String)"EndTime must not be null");
        return startTime.getTime() <= endTime.getTime();
    }

    public static boolean isStartOfTheMonth(Date date) {
        Assert.notNull((Object)date, (String)"date must not be null.");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return 1 == calendar.get(5);
    }

    public static boolean isStartOfTheYear(Date date) {
        Assert.notNull((Object)date, (String)"date must not be null.");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return 0 == calendar.get(2) && 1 == calendar.get(5);
    }

    public static int getMonth(Date date) {
        Assert.notNull((Object)date, (String)"date must not be null.");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DateUtil.convertCalendarMonthToRealMonth(calendar.get(2));
    }

    public static int getYear(Date date) {
        Assert.notNull((Object)date, (String)"date must not be null.");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static int getDayOfWeek(Date date) {
        Assert.notNull((Object)date, (String)"date must not be null.");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(7) - 1;
    }

    public static int getDayOfMonth(Date date) {
        Assert.notNull((Object)date, (String)"date must not be null.");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static int getDayOfYear(Date date) {
        Assert.notNull((Object)date, (String)"date must not be null.");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(6);
    }

    public static int getHour(Date date) {
        Assert.notNull((Object)date, (String)"date must not be null.");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(11);
    }

    public static int getMinute(Date date) {
        Assert.notNull((Object)date, (String)"date must not be null.");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(12);
    }

    public static int getSecond(Date date) {
        Assert.notNull((Object)date, (String)"date must not be null.");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(13);
    }

    public static Timestamp getSystemTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static Date getSystemDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return new Date(calendar.getTime().getTime());
    }

    public static Date getCurrentDate() {
        return new Date();
    }

    public static String getCurrentTime(String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(new Date());
    }

    public static String getCurrentTimeForms() {
        return DateUtil.getCurrentTime("yyyyMMddHHmmssSSS");
    }

    public static String getCurrentTimeFors() {
        return DateUtil.getCurrentTime("yyyyMMddHHmmss");
    }

    public static String getCurrentDate_YYYYMMDD() {
        return DateUtil.getCurrentTime("yyyyMMdd");
    }

    public static boolean isValidDate(String dateStr, String pattern) {
        if (dateStr == null || "".equals(dateStr.trim())) {
            return false;
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        try {
            format.setLenient(false);
            format.parse(dateStr);
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    public static String timeMillisForSid16() {
        String sid = System.currentTimeMillis() + "";
        int len = sid.length() - 16;
        if (len > 0) {
            sid = sid.substring(len, len + 16);
        } else if (len < 0) {
            for (int i = 0; i < Math.abs(len); ++i) {
                sid = "0" + sid;
            }
        }
        return sid;
    }

    public static Date addSeconds(Date date, int numSeconds) {
        Assert.notNull((Object)date, (String)"date must not be null.");
        return DateUtils.addSeconds((Date)date, (int)numSeconds);
    }

    public static Date addDays(Date date, int numDays) {
        Assert.notNull((Object)date, (String)"date must not be null.");
        return DateUtils.addDays((Date)date, (int)numDays);
    }

    public static Date addHours(Date date, int numHours) {
        Assert.notNull((Object)date, (String)"date must not be null.");
        return DateUtils.addHours((Date)date, (int)numHours);
    }

    public static Date addMinutes(Date date, int numMins) {
        Assert.notNull((Object)date, (String)"date must not be null.");
        return DateUtils.addMinutes((Date)date, (int)numMins);
    }

    public static Date addMonths(Date date, int numMonths) {
        Assert.notNull((Object)date, (String)"date must not be null.");
        return DateUtils.addMonths((Date)date, (int)numMonths);
    }

    public static Date addYears(Date date, int numYears) {
        Assert.notNull((Object)date, (String)"date must not be null.");
        return DateUtils.addYears((Date)date, (int)numYears);
    }

    public static Date resetTime(Date date) {
        Assert.notNull((Object)date, (String)"date must not be null.");
        return DateUtil.getDate(DateUtil.getYear(date), DateUtil.getMonth(date), DateUtil.getDayOfMonth(date));
    }

    private static int convertRealMonthToCalendarMonth(int realMonth) {
        return realMonth - 1;
    }

    private static int convertCalendarMonthToRealMonth(int calendarMonth) {
        return calendarMonth + 1;
    }

    public static Date getFirstDayOfMonthForDB(Date today) {
        int year = DateUtil.getYear(today);
        int month = DateUtil.getMonth(today);
        if (DateUtil.getDayOfMonth(today) == 1) {
            --month;
        }
        if (month == 0) {
            --year;
            month = 12;
        }
        return DateUtil.getDate(year, month, 1);
    }

    public static Date getLastDayOfMonthForDB(Date today) {
        int year = DateUtil.getYear(today);
        int month = DateUtil.getMonth(today);
        if (DateUtil.getDayOfMonth(today) != 1) {
            ++month;
        }
        if (month == 13) {
            month = 1;
            ++year;
        }
        return DateUtil.getDate(year, month, 1);
    }

    public static Date getFirstDayOfQuarterForDB(Date today) {
        int year = DateUtil.getYear(today);
        int month = DateUtil.getMonth(today);
        int day = DateUtil.getDayOfMonth(today);
        if (day == 1) {
            if (month == 4 || month == 7 || month == 10) {
                month -= 3;
            } else if (month == 1) {
                month = 10;
                --year;
            }
        }
        if (month >= 1 && month <= 3) {
            month = 1;
        } else if (month >= 4 && month <= 6) {
            month = 4;
        } else if (month >= 7 && month <= 9) {
            month = 7;
        } else if (month >= 10 && month <= 12) {
            month = 10;
        }
        return DateUtil.getDate(year, month, 1);
    }

    public static Date getLastDayOfQuarterForDB(Date today) {
        int year = DateUtil.getYear(today);
        int month = DateUtil.getMonth(today);
        int day = DateUtil.getDayOfMonth(today);
        if (month != 1 && month != 4 && month != 7 && month != 10) {
            if (month >= 1 && month <= 3) {
                month = 4;
            } else if (month >= 4 && month <= 6) {
                month = 7;
            } else if (month >= 7 && month <= 9) {
                month = 10;
            } else if (month >= 10 && month <= 12) {
                month = 1;
                ++year;
            }
        }
        return DateUtil.getDate(year, month, 1);
    }

    public static String getDiffFromNow(Date date) {
        Date nowDate = new Date();
        Long nowLong = nowDate.getTime() / 1000L;
        Long dateLong = date.getTime() / 1000L;
        String returnValue = "";
        Long diffLong = nowLong - dateLong;
        Long secondLong = diffLong / 60L;
        if (secondLong == 0L) {
            returnValue = "\u4e0d\u52301\u5206\u949f\u524d";
        } else if (secondLong < 60L) {
            returnValue = secondLong + "\u5206\u949f\u524d";
        } else {
            Long hourLong = secondLong / 60L;
            secondLong = secondLong - 60L * hourLong;
            returnValue = hourLong + "\u5c0f\u65f6" + secondLong + "\u5206\u949f\u524d";
        }
        return returnValue;
    }

    public static Date getFirstDateOfTheMonth(String month, String pattern) {
        Date thisDate = "".equals(pattern) ? DateUtil.parseDate(month) : DateUtil.parseDate(month, pattern);
        Assert.notNull((Object)thisDate, (String)"date must not be null.");
        if (DateUtil.isStartOfTheMonth(thisDate)) {
            return thisDate;
        }
        int thisYear = DateUtil.getYear(thisDate);
        int thisMonth = DateUtil.getMonth(thisDate);
        int thisDay = 1;
        return DateUtil.getDate(thisYear, thisMonth, thisDay);
    }

    public static Date getFirstDateOfTheMonth(Date date) {
        Assert.notNull((Object)date, (String)"date must not be null.");
        if (DateUtil.isStartOfTheMonth(date)) {
            return date;
        }
        int thisYear = DateUtil.getYear(date);
        int thisMonth = DateUtil.getMonth(date);
        int thisDay = 1;
        return DateUtil.getDate(thisYear, thisMonth, thisDay);
    }

    public static Date getLastDateOfTheMonth(String month, String pattern) {
        Date firstDateOfTheMonth = DateUtil.getFirstDateOfTheMonth(month, pattern);
        Assert.notNull((Object)firstDateOfTheMonth, (String)"date must not be null.");
        int daysOfTheMonth = DateUtil.getLastDayOfTheMonth(firstDateOfTheMonth) - 1;
        Date lastDateOfTheMonth = DateUtil.addDays(firstDateOfTheMonth, daysOfTheMonth);
        return lastDateOfTheMonth;
    }

    public static Date getLastDateOfTheMonth(Date date) {
        Date firstDateOfTheMonth = DateUtil.getFirstDateOfTheMonth(date);
        Assert.notNull((Object)firstDateOfTheMonth, (String)"date must not be null.");
        int daysOfTheMonth = DateUtil.getLastDayOfTheMonth(firstDateOfTheMonth) - 1;
        Date lastDateOfTheMonth = DateUtil.addDays(firstDateOfTheMonth, daysOfTheMonth);
        return lastDateOfTheMonth;
    }

    public static int getYear() {
        GregorianCalendar calendar = new GregorianCalendar();
        int year = calendar.get(1);
        return year;
    }

    public static int getMonth() {
        GregorianCalendar calendar = new GregorianCalendar();
        int month = calendar.get(2) + 1;
        return month;
    }

    public static int getDay() {
        GregorianCalendar calendar = new GregorianCalendar();
        int day = calendar.get(5);
        return day;
    }

    public static Date getDateAfterSeconds(int seconds) {
        long now = System.currentTimeMillis() + (long)(seconds * 1000);
        return new Date(now);
    }

    public static double getDiffDatetime(Date startDatetime, Date endDatetime, TimeUnit timeUnit) {
        long start = startDatetime.getTime();
        long end = endDatetime.getTime();
        long apple = end - start;
        double result = apple;
        result = TimeUnit.DAYS == timeUnit ? (double)TimeUnit.MILLISECONDS.toDays(apple) : (TimeUnit.HOURS == timeUnit ? (double)TimeUnit.MILLISECONDS.toHours(apple) : (TimeUnit.MINUTES == timeUnit ? (double)TimeUnit.MILLISECONDS.toMinutes(apple) : (TimeUnit.SECONDS == timeUnit ? (double)TimeUnit.MILLISECONDS.toSeconds(apple) : (TimeUnit.MILLISECONDS == timeUnit ? (double)TimeUnit.MILLISECONDS.toMillis(apple) : (double)apple))));
        return result;
    }

    public static double getDatetimeGap(Date startDatetime, Date endDatetime, Integer dateType) {
        Assert.notNull((Object)startDatetime, (String)"startDatetime must  not be null");
        Assert.notNull((Object)startDatetime, (String)"endDatetime must not be null");
        long apple = endDatetime.getTime() - startDatetime.getTime();
        if (dateType == null) {
            return apple;
        }
        if (dateType == 1) {
            return (double)apple / 4.74877952E8;
        }
        if (dateType == 2) {
            return (double)apple / 1.0368E9;
        }
        if (dateType == 6) {
            return (double)apple / 8.64E7;
        }
        if (dateType == 10) {
            return (double)apple / 3600000.0;
        }
        if (dateType == 12) {
            return (double)apple / 60000.0;
        }
        if (dateType == 13) {
            return apple / 1000L;
        }
        if (dateType == 14) {
            return apple;
        }
        return apple;
    }

    public static String getDataString(String s) {
        String y = s.substring(0, 4);
        String m = s.substring(5, 7);
        String d = s.substring(8, 10);
        String h = s.substring(11, 13);
        String mi = s.substring(14, 16);
        String se = s.substring(17, 19);
        return String.valueOf(y) + m + d + h + mi + se;
    }

    public static Date getFristDayOfThisMonth(String datetime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtil.parseDate(datetime));
        calendar.set(5, 1);
        Date date = new Date(calendar.getTime().getTime());
        return date;
    }

    public static String getCurrentMonthEnd() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.getCurrentDate());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        int year = cal.get(1);
        int month = cal.get(2);
        if (month == 0) {
            --year;
            month = 12;
        } else {
            --month;
        }
        String currentMonthEnd = String.valueOf(String.valueOf(year)) + String.valueOf(month);
        return currentMonthEnd;
    }

    public static boolean isAfterToday(Date date) {
        return date != null && date.after(new Date());
    }

    public static int getMonthDays(int year, int month) {
        int[] days = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        if (2 == month && 0 == year % 4 && (0 != year % 100 || 0 == year % 400)) {
            days[1] = 29;
        }
        return days[month - 1];
    }

    public static int getCurMonthDays() {
        int year = Calendar.getInstance().get(1);
        int month = Calendar.getInstance().get(2) + 1;
        return DateUtil.getMonthDays(year, month);
    }

    public static String getWeekday(String dateStr) throws Exception {
        Date date = DateUtil.parseDate(dateStr);
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return new SimpleDateFormat("EEEE").format(c.getTime());
    }

    public static String getWeekday(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return new SimpleDateFormat("EEEE").format(c.getTime());
    }
}

