/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public abstract class IOUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getByteArray(InputStream ins) {
        if (ins == null) {
            return null;
        }
        ArrayList<Integer> byteList = new ArrayList<Integer>();
        byte[] result = null;
        try {
            Integer offset;
            while ((offset = Integer.valueOf(ins.read())) != -1) {
                byteList.add(offset);
            }
            result = new byte[byteList.size()];
            for (int i = 0; i < byteList.size(); ++i) {
                int temp = (Integer)byteList.get(i);
                result[i] = (byte)temp;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.close(ins);
        }
        return result;
    }

    public static byte[] getStreamAsByteArray(InputStream ins) {
        return IOUtils.getStreamAsByteArray(ins, 4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getStreamAsByteArray(InputStream ins, int blength) {
        int bufferlength = 4096;
        if (ins == null) {
            return null;
        }
        bufferlength = blength < 0 ? 4096 : blength;
        byte[] result = null;
        ByteArrayOutputStream outstream = new ByteArrayOutputStream(bufferlength);
        byte[] buffer = new byte[bufferlength];
        try {
            int len;
            while ((len = ins.read(buffer)) != -1) {
                outstream.write(buffer, 0, len);
            }
            result = outstream.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.close(ins);
            IOUtils.close(outstream);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveWrite(InputStream ins, OutputStream os) {
        if (ins == null) {
            throw new NullPointerException("InputStream[ins] is not  null.");
        }
        if (os == null) {
            throw new NullPointerException("OutputStream[os] is not  null.");
        }
        try {
            Integer offset;
            while ((offset = Integer.valueOf(ins.read())) != -1) {
                os.write(offset);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.close(os);
            IOUtils.close(ins);
        }
    }

    public static void close(Object io) {
        if (io instanceof Closeable) {
            Closeable closeIO = (Closeable)io;
            IOUtils.close(closeIO);
        }
    }

    public static void close(Closeable io) {
        if (io == null) {
            return;
        }
        try {
            if (io instanceof InputStream) {
                InputStream ins = (InputStream)io;
                ins.close();
            } else if (io instanceof OutputStream) {
                OutputStream os = (OutputStream)io;
                os.flush();
                os.close();
            } else {
                io.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

