/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.util;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.ocpsoft.prettytime.PrettyTime;

public class PrettyUtils {
    private static final int UNIT = 1024;

    public static String prettyByteSize(long byteSize) {
        double size = 1.0 * (double)byteSize;
        String type = "B";
        if ((int)Math.floor(size / 1024.0) <= 0) {
            type = "B";
            return PrettyUtils.format(size, type);
        }
        if ((int)Math.floor((size /= 1024.0) / 1024.0) <= 0) {
            type = "KB";
            return PrettyUtils.format(size, type);
        }
        if ((int)Math.floor((size /= 1024.0) / 1024.0) <= 0) {
            type = "MB";
            return PrettyUtils.format(size, type);
        }
        if ((int)Math.floor((size /= 1024.0) / 1024.0) <= 0) {
            type = "GB";
            return PrettyUtils.format(size, type);
        }
        if ((int)Math.floor((size /= 1024.0) / 1024.0) <= 0) {
            type = "TB";
            return PrettyUtils.format(size, type);
        }
        if ((int)Math.floor((size /= 1024.0) / 1024.0) <= 0) {
            type = "PB";
            return PrettyUtils.format(size, type);
        }
        return ">PB";
    }

    private static String format(double size, String type) {
        int precision = 0;
        precision = size * 1000.0 % 10.0 > 0.0 ? 3 : (size * 100.0 % 10.0 > 0.0 ? 2 : (size * 10.0 % 10.0 > 0.0 ? 1 : 0));
        String formatStr = "%." + precision + "f";
        if ("KB".equals(type)) {
            return String.format(formatStr, size) + "KB";
        }
        if ("MB".equals(type)) {
            return String.format(formatStr, size) + "MB";
        }
        if ("GB".equals(type)) {
            return String.format(formatStr, size) + "GB";
        }
        if ("TB".equals(type)) {
            return String.format(formatStr, size) + "TB";
        }
        if ("PB".equals(type)) {
            return String.format(formatStr, size) + "PB";
        }
        return String.format(formatStr, size) + "B";
    }

    public static final String prettySeconds(int totalSeconds) {
        StringBuilder s = new StringBuilder();
        int second = totalSeconds % 60;
        if (totalSeconds > 0) {
            s.append("\u79d2");
            s.append(StringUtils.reverse((String)String.valueOf(second)));
        }
        int minute = (totalSeconds /= 60) % 60;
        if (totalSeconds > 0) {
            s.append("\u5206");
            s.append(StringUtils.reverse((String)String.valueOf(minute)));
        }
        int hour = (totalSeconds /= 60) % 24;
        if (totalSeconds > 0) {
            s.append(StringUtils.reverse((String)"\u5c0f\u65f6"));
            s.append(StringUtils.reverse((String)String.valueOf(hour)));
        }
        int day = (totalSeconds /= 24) % 31;
        if (totalSeconds > 0) {
            s.append("\u5929");
            s.append(StringUtils.reverse((String)String.valueOf(day)));
        }
        int month = (totalSeconds /= 31) % 12;
        if (totalSeconds > 0) {
            s.append("\u6708");
            s.append(StringUtils.reverse((String)String.valueOf(month)));
        }
        int year = totalSeconds /= 12;
        if (totalSeconds > 0) {
            s.append("\u5e74");
            s.append(StringUtils.reverse((String)String.valueOf(year)));
        }
        return s.reverse().toString();
    }

    public static final String prettyTime(Date date) {
        PrettyTime p = new PrettyTime();
        return p.format(date);
    }

    public static final String prettyTime(long millisecond) {
        PrettyTime p = new PrettyTime();
        return p.format(new Date(millisecond));
    }

    public static void main(String[] args) {
        System.out.println(PrettyUtils.prettyByteSize(102600000L));
        System.out.println(PrettyUtils.prettyByteSize(1024L));
        System.out.println(PrettyUtils.prettyByteSize(0x100000L));
        System.out.println(PrettyUtils.prettyByteSize(1047552L));
        System.out.println(PrettyUtils.prettyByteSize(1070599167L));
        System.out.println(PrettyUtils.prettyByteSize(0x40000000L));
        System.out.println(PrettyUtils.prettyByteSize(0x10000000000L));
        System.out.println(PrettyUtils.prettyByteSize(0x4000000000000L));
        System.out.println(PrettyUtils.prettyByteSize(0x1000000000000000L));
        System.out.println("-----------");
        System.out.println(PrettyUtils.prettyTime(new Date()));
        System.out.println(PrettyUtils.prettyTime(123L));
        System.out.println(PrettyUtils.prettySeconds(10));
        System.out.println(PrettyUtils.prettySeconds(61));
        System.out.println(PrettyUtils.prettySeconds(3661));
        System.out.println(PrettyUtils.prettySeconds(36611));
        System.out.println(PrettyUtils.prettySeconds(366111));
        System.out.println(PrettyUtils.prettySeconds(0x37DD37));
        System.out.println(PrettyUtils.prettySeconds(36611111));
    }
}

