/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nbone.util.PropertiesExt;
import org.nbone.util.ResourceUtil;

public class PropertiesUtil {
    protected static final Log logger = LogFactory.getLog(PropertiesUtil.class);
    private static Map<String, PropertiesExt> propsExtMap = new HashMap<String, PropertiesExt>();
    private static final String CHARSET_ISO_8859_1 = "ISO-8859-1";
    private static final String CHARSET_UTF_8 = "UTF-8";

    private static InputStream getTwoResourceAsStream(String p_location) throws IOException {
        try {
            InputStream in = ResourceUtil.getResourceAsStream(p_location);
            if (in != null) {
                // empty if block
            }
            return in;
        }
        catch (Exception e) {
            throw new IOException("failed loading Properties resource from " + p_location);
        }
    }

    private static InputStream getResourceAsStream(String p_location) {
        InputStream in = null;
        File file = null;
        try {
            file = ResourceUtil.getResourceFile(p_location);
            if (file != null) {
                in = new FileInputStream(file);
            }
            if (in == null) {
                in = PropertiesUtil.getTwoResourceAsStream(p_location);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return in;
    }

    public static Properties loadPropertiesFile(String aFilePath) throws IOException {
        try (InputStream in = null;){
            Properties properties = new Properties();
            File file = ResourceUtil.getResourceFile(aFilePath);
            in = new FileInputStream(file);
            properties.load(in);
            Properties properties2 = properties;
            return properties2;
        }
    }

    public static Properties loadPropertiesResource(String aResourcePath) throws IOException {
        try (InputStream in = PropertiesUtil.getTwoResourceAsStream(aResourcePath);){
            Properties properties = new Properties();
            properties.load(in);
            Properties properties2 = properties;
            return properties2;
        }
    }

    public static Properties loadProperties(String location) {
        if (location == null) {
            throw new NullPointerException("Properties File Path must not is null.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)new StringBuilder("Properties File Path: ").append(location));
        }
        Properties properties = null;
        try {
            properties = PropertiesUtil.loadPropertiesFile(location);
            PropertiesUtil.setLoadMethod(location, "LoadForFile");
        }
        catch (IOException e) {
            try {
                logger.warn((Object)("cannot load " + location + " from filePath, will try from classpath"));
                properties = PropertiesUtil.loadPropertiesResource(location);
                PropertiesUtil.setLoadMethod(location, "LoadForResource");
            }
            catch (Exception e2) {
                logger.error((Object)("cannot load properties file from " + location), (Throwable)e);
                throw new RuntimeException("cannot load properties file from : " + location);
            }
        }
        return properties;
    }

    public static Properties getProperties(String location) {
        return PropertiesUtil.getProperties(location, 2);
    }

    public static Properties getProperties(String location, int loadType) {
        switch (loadType) {
            case 1: {
                if (PropertiesUtil.isLoad(location)) break;
                PropertiesUtil.initializePropertiesX(location, loadType);
                break;
            }
            case 2: {
                if (PropertiesUtil.isLoad(location) && !PropertiesUtil.isModified(location)) break;
                PropertiesUtil.initializePropertiesX(location, loadType);
                break;
            }
        }
        Properties props = propsExtMap.get(location).getProperties();
        return props;
    }

    private static void initializePropertiesX(String location, int loadType) {
        PropertiesExt propsExt = propsExtMap.get(location);
        if (propsExt == null) {
            propsExt = new PropertiesExt(loadType);
            propsExtMap.put(location, propsExt);
        }
        Properties properties = PropertiesUtil.loadProperties(location);
        propsExt.setProperties(properties);
        propsExt.setHasLoad(true);
    }

    public static String getString(String key, String location) {
        Properties properties = PropertiesUtil.getProperties(location);
        String propertyValue = properties.getProperty(key);
        return propertyValue;
    }

    public static List<String> getList(String key, String location) {
        Properties properties = PropertiesUtil.getProperties(location);
        ArrayList<String> list = new ArrayList<String>();
        if (key == null || key.equals("")) {
            return list;
        }
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = (String)propertyNames.nextElement();
            if (propertyName == null || propertyName.indexOf(key) < 0) continue;
            String propertyValue = properties.getProperty(propertyName);
            list.add(propertyValue);
        }
        return list;
    }

    private static boolean isLoad(String location) {
        PropertiesExt propsExt = propsExtMap.get(location);
        if (propsExt == null) {
            return false;
        }
        return propsExt.isHasLoad();
    }

    private static boolean isDynamicLoad(String location) {
        PropertiesExt propsExt = propsExtMap.get(location);
        if (propsExt == null) {
            return true;
        }
        return propsExt.getLoadType() == 2;
    }

    private static void setLoadType(String location, int loadType) {
        PropertiesExt propsExt = propsExtMap.get(location);
        if (propsExt != null) {
            propsExt.setLoadType(loadType);
        }
    }

    private static void setLoadMethod(String location, String loadMethod) {
        PropertiesExt propsExt = propsExtMap.get(location);
        if (propsExt != null) {
            propsExt.setLoadMethod(loadMethod);
        }
    }

    private static String getLoadMethod(String location) {
        PropertiesExt propsExt = propsExtMap.get(location);
        if (propsExt == null) {
            return null;
        }
        return propsExt.getLoadMethod();
    }

    private static long getLastModif(String location) {
        PropertiesExt propsExt = propsExtMap.get(location);
        if (propsExt == null) {
            return 0L;
        }
        return propsExt.getLastModifTime();
    }

    private static void setLastModif(String location, long lastModif) {
        PropertiesExt propsExt = propsExtMap.get(location);
        if (propsExt != null) {
            propsExt.setLastModifTime(lastModif);
        }
    }

    private static boolean isModified(String location) {
        if (location == null) {
            throw new NullPointerException("Properties File Path not be null.");
        }
        try {
            if (!PropertiesUtil.isDynamicLoad(location)) {
                return false;
            }
            long newTime = 0L;
            String loadMethod = PropertiesUtil.getLoadMethod(location);
            if ("LoadForFile".equals(loadMethod)) {
                File file = ResourceUtil.getResourceFile(location);
                if (file == null) {
                    return false;
                }
                boolean fileExists = file.exists();
                if (fileExists) {
                    newTime = file.lastModified();
                }
            } else {
                URL url = ResourceUtil.getResourceURL(location);
                URLConnection conn = url.openConnection();
                newTime = conn.getLastModified();
            }
            long lastModif = PropertiesUtil.getLastModif(location);
            if (newTime > lastModif) {
                lastModif = newTime;
                PropertiesUtil.setLastModif(location, lastModif);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)new StringBuilder(location).append("[file already Modified:").append(new Timestamp(lastModif)).append("]"));
                }
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }
}

