/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Timestamp;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.ResourceUtils;

public abstract class ResourceUtil {
    protected static final Log logger = LogFactory.getLog(ResourceUtil.class);

    public static URL getResourceURL(String p_location) {
        URL url = null;
        try {
            ClassLoader cl = ClassUtils.getDefaultClassLoader();
            url = cl.getResource(p_location);
        }
        catch (Exception e) {
            logger.warn((Object)new StringBuilder(p_location).append(": not to URL, URL Return null."));
            return null;
        }
        return url;
    }

    public static InputStream getResourceAsStream(String p_location) {
        ClassLoader cl = ClassUtils.getDefaultClassLoader();
        InputStream in = cl.getResourceAsStream(p_location);
        return in;
    }

    public static File getResourceFile(String p_location) throws IOException {
        File file = null;
        URL url = ResourceUtil.getResourceURL(p_location);
        try {
            file = url == null ? ResourceUtils.getFile((String)p_location) : ResourceUtils.getFile((URL)url);
            return file;
        }
        catch (Exception e) {
            throw new IOException("loading file failed. from " + p_location);
        }
    }

    public static void main(String[] args) {
        long time1 = 1442304831125L;
        Timestamp time = new Timestamp(1442304831125L);
        System.out.println(time);
    }
}

