/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nbone.constants.ContentType;
import org.nbone.util.IOUtils;

public abstract class WebIOUtils
extends IOUtils
implements ContentType {
    protected Log logger = LogFactory.getLog(WebIOUtils.class);
    public static final String DEFAULT_ECODING = "UTF-8";
    public static final String SUB_CHARSET = ";charset";

    public static ServletResponse setResponse(ServletResponse response, String contentType, String encoding) {
        if (response == null) {
            return null;
        }
        response.reset();
        String type = contentType;
        String charset = encoding;
        if (contentType == null) {
            type = "text/html";
        }
        if (encoding == null) {
            charset = DEFAULT_ECODING;
        }
        if (type.indexOf(SUB_CHARSET) == -1) {
            type = type + ";charset=" + charset;
        }
        response.setContentType(type);
        response.setCharacterEncoding(charset);
        return response;
    }

    public static HttpServletResponse attachmentName(HttpServletResponse response, String contentType, String encoding, String fileName) throws UnsupportedEncodingException {
        if (response == null) {
            return null;
        }
        WebIOUtils.setResponse((ServletResponse)response, contentType, encoding);
        if (encoding == null) {
            encoding = DEFAULT_ECODING;
        }
        if (fileName != null) {
            response.addHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes(), encoding));
        }
        return response;
    }

    public static void exportResource(ServletResponse response, String resourceType, InputStream ins) {
        WebIOUtils.exportResource(response, resourceType, ins, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportResource(ServletResponse response, String resourceType, byte[] bin) {
        WebIOUtils.setResponse(response, resourceType, DEFAULT_ECODING);
        ServletOutputStream os = null;
        try {
            os = response.getOutputStream();
            os.write(bin);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            WebIOUtils.close((Closeable)os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportResource(ServletResponse response, String resourceType, InputStream ins, String fileName) {
        HttpServletResponse response1 = (HttpServletResponse)response;
        ServletOutputStream os = null;
        try {
            WebIOUtils.attachmentName(response1, resourceType, DEFAULT_ECODING, fileName);
            os = response1.getOutputStream();
            WebIOUtils.saveWrite(ins, (OutputStream)os);
            WebIOUtils.close((Closeable)os);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            WebIOUtils.close(os);
        }
    }

    public static OutputStream getOutputStream(HttpServletResponse response, String resourceType, String fileName) throws IOException {
        WebIOUtils.attachmentName(response, resourceType, DEFAULT_ECODING, fileName);
        return response.getOutputStream();
    }

    public static Writer getWriter(HttpServletResponse response, String resourceType, String fileName) throws IOException {
        WebIOUtils.attachmentName(response, resourceType, DEFAULT_ECODING, fileName);
        return response.getWriter();
    }

    public static OutputStream getImageOutputStream(HttpServletResponse response) throws IOException {
        OutputStream os = WebIOUtils.getOutputStream(response, "image/jpeg", null);
        return os;
    }

    public static OutputStream getExcelOutputStream(HttpServletResponse response, String fileName) throws IOException {
        OutputStream os = WebIOUtils.getOutputStream(response, "application/x-msexcel", fileName);
        return os;
    }

    public static OutputStream getTxtOutputStream(HttpServletResponse response, String fileName) throws IOException {
        OutputStream os = WebIOUtils.getOutputStream(response, "text/plain", fileName);
        return os;
    }
}

