/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.util.concurrent;

import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CountDownLatchRunnable
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(CountDownLatchRunnable.class);
    private final CountDownLatch countDownLatch;
    private int index;
    private Object[] results;

    public CountDownLatchRunnable(CountDownLatch countDownLatch, int index, Object[] results) {
        this.countDownLatch = countDownLatch;
        this.index = index;
        this.results = results;
    }

    @Override
    public void run() {
        try {
            this.results[this.index] = this.doExecute();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.countDownLatch.countDown();
        }
    }

    protected abstract Object doExecute();
}

