/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.util.concurrent;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import org.nbone.util.concurrent.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ExecutorServices {
    private static final Logger logger = LoggerFactory.getLogger(ExecutorServices.class);

    public static <T, R> List<R> parallelRun(ExecutorService executorService, Collection<T> collection, final Invoker<T, R> invoker) {
        if (CollectionUtils.isEmpty(collection)) {
            return Collections.emptyList();
        }
        final Object[] results = new Object[collection.size()];
        final CountDownLatch countDownLatch = new CountDownLatch(collection.size());
        int count = 0;
        for (final T bean : collection) {
            final int index = count++;
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        results[index] = invoker.invoke(bean);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                }
            });
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return Arrays.asList(results);
    }

    public static <T, R> List<R> parallelRun(Collection<T> collection, Invoker<T, R> invoker) {
        return ExecutorServices.parallelRun(ThreadPool.genericExecutor(), collection, invoker);
    }

    public static interface Invoker<T, R> {
        public R invoke(T var1);
    }
}

