/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.util.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.nbone.util.concurrent.NamedThreadFactory;

public class ThreadPool {
    public static final String GENERIC = "generic";
    private static ThreadPoolExecutor genericExecutor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ThreadPoolExecutor genericExecutor() {
        if (genericExecutor != null) return genericExecutor;
        Class<ThreadPool> clazz = ThreadPool.class;
        synchronized (ThreadPool.class) {
            if (genericExecutor != null) return genericExecutor;
            int genericThreadPoolMax = ThreadPool.boundedBy(4 * Runtime.getRuntime().availableProcessors(), 128, 512);
            genericExecutor = ThreadPool.makeScalingExecutor(4, genericThreadPoolMax, GENERIC);
            // ** MonitorExit[var0] (shouldn't be in output)
            return genericExecutor;
        }
    }

    public static ThreadPoolExecutor makeScalingExecutor(int min, int max, String serverName) {
        ThreadPoolExecutor executor;
        ExecutorScalingQueue<Runnable> queue = new ExecutorScalingQueue<Runnable>();
        queue.executor = executor = ThreadPool.makeThreadPool(min, max, 60L, queue, serverName);
        return executor;
    }

    public static ThreadPoolExecutor makeFixedThreadPool(int size, int queueCapacity, String serverName) {
        return ThreadPool.makeThreadPool(size, size, 60L, queueCapacity, serverName);
    }

    public static ThreadPoolExecutor makeThreadPool(int core, String serverName) {
        return ThreadPool.makeThreadPool(core, 200, 60L, 1000, serverName);
    }

    public static ThreadPoolExecutor makeThreadPool(int core, int max, String serverName) {
        return ThreadPool.makeThreadPool(core, max, 60L, 1000, serverName);
    }

    public static ThreadPoolExecutor makeThreadPool(int core, int max, long keepAliveTime, int queueCapacity, String serverName) {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(core, max, keepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(queueCapacity), new NamedThreadFactory(serverName));
        return threadPoolExecutor;
    }

    public static ThreadPoolExecutor makeThreadPool(int core, int max, long keepAliveTime, BlockingQueue<Runnable> workQueue, String serverName) {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(core, max, keepAliveTime, TimeUnit.SECONDS, workQueue, new NamedThreadFactory(serverName));
        return threadPoolExecutor;
    }

    static int boundedBy(int value, int min, int max) {
        return Math.min(max, Math.max(min, value));
    }

    static class ExecutorScalingQueue<E>
    extends LinkedTransferQueue<E> {
        ThreadPoolExecutor executor;

        ExecutorScalingQueue() {
        }

        @Override
        public boolean offer(E e) {
            if (!this.tryTransfer(e)) {
                int left = this.executor.getMaximumPoolSize() - this.executor.getCorePoolSize();
                if (left > 0) {
                    return false;
                }
                return super.offer(e);
            }
            return true;
        }
    }
}

