/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.util.file.excel.jxl;

import java.io.File;
import java.io.InputStream;
import java.util.Date;
import jxl.BooleanCell;
import jxl.BooleanFormulaCell;
import jxl.Cell;
import jxl.CellType;
import jxl.DateCell;
import jxl.ErrorCell;
import jxl.FormulaCell;
import jxl.LabelCell;
import jxl.NumberCell;
import jxl.NumberFormulaCell;
import jxl.Sheet;
import jxl.StringFormulaCell;
import jxl.Workbook;
import jxl.biff.EmptyCell;
import org.nbone.util.DateUtil;
import org.nbone.util.file.excel.jxl.ExcelUtils;

public class ExcelOper {
    private Workbook workbook;
    private Sheet currentSheet;

    public ExcelOper() {
    }

    public ExcelOper(File file) {
        Workbook workbook = ExcelUtils.getWorkbook(file);
        if (workbook != null) {
            this.setWorkbook(workbook);
        }
    }

    public ExcelOper(InputStream ins) {
        Workbook workbook = ExcelUtils.getWorkbook(ins);
        if (workbook != null) {
            this.setWorkbook(workbook);
        }
    }

    public ExcelOper(Workbook workbook) {
        this.setWorkbook(workbook);
    }

    public void setWorkbook(Workbook workbook) {
        this.workbook = workbook;
        this.currentSheet = workbook.getSheet(0);
    }

    public void setCurrentSheet(int sheetNum) {
        this.currentSheet = this.workbook.getSheet(sheetNum);
    }

    public Cell getCell(int rowNum, int colNum) {
        return this.currentSheet.getCell(rowNum, colNum);
    }

    public Cell[] getRowCells(int rowNum) {
        return this.currentSheet.getRow(rowNum);
    }

    public Cell[] getColCells(int colNum) {
        return this.currentSheet.getColumn(colNum);
    }

    public int getRows() {
        return this.currentSheet.getRows();
    }

    public int getCols() {
        return this.currentSheet.getColumns();
    }

    public EmptyCell getEmptyCell(int rowNum, int colNum) {
        Cell cell = this.getCell(rowNum, colNum);
        if (cell instanceof EmptyCell) {
            return (EmptyCell)cell;
        }
        return null;
    }

    public BooleanCell getBooleanCell(int rowNum, int colNum) {
        Cell cell = this.getCell(rowNum, colNum);
        if (cell instanceof BooleanCell) {
            return (BooleanCell)cell;
        }
        return null;
    }

    public BooleanFormulaCell getBooleanFormulaCell(int rowNum, int colNum) {
        Cell cell = this.getCell(rowNum, colNum);
        if (cell instanceof BooleanFormulaCell) {
            return (BooleanFormulaCell)cell;
        }
        return null;
    }

    public DateCell getDateCell(int rowNum, int colNum) {
        Cell cell = this.getCell(rowNum, colNum);
        if (cell instanceof DateCell) {
            return (DateCell)cell;
        }
        return null;
    }

    public ErrorCell getErrorCell(int rowNum, int colNum) {
        Cell cell = this.getCell(rowNum, colNum);
        if (cell instanceof ErrorCell) {
            return (ErrorCell)cell;
        }
        return null;
    }

    public FormulaCell getFormulaCell(int rowNum, int colNum) {
        Cell cell = this.getCell(rowNum, colNum);
        if (cell instanceof FormulaCell) {
            return (FormulaCell)cell;
        }
        return null;
    }

    public LabelCell getLabelCell(int rowNum, int colNum) {
        Cell cell = this.getCell(rowNum, colNum);
        if (cell instanceof LabelCell) {
            return (LabelCell)cell;
        }
        return null;
    }

    public NumberCell getNumberCell(int rowNum, int colNum) {
        Cell cell = this.getCell(rowNum, colNum);
        if (cell instanceof NumberCell) {
            return (NumberCell)cell;
        }
        return null;
    }

    public NumberFormulaCell getNumberFormulaCell(int rowNum, int colNum) {
        Cell cell = this.getCell(rowNum, colNum);
        if (cell instanceof NumberFormulaCell) {
            return (NumberFormulaCell)cell;
        }
        return null;
    }

    public StringFormulaCell getStringFormula(int rowNum, int colNum) {
        Cell cell = this.getCell(rowNum, colNum);
        if (cell instanceof StringFormulaCell) {
            return (StringFormulaCell)cell;
        }
        return null;
    }

    public Date getCellDate(int rowNum, int colNum) {
        DateCell dateCell = this.getDateCell(rowNum, colNum);
        return dateCell.getDate();
    }

    public String getCellStr(int rowNum, int colNum) {
        LabelCell labelCell = this.getLabelCell(rowNum, colNum);
        return labelCell.getContents();
    }

    public String getCellStrValue(int rowNum, int colNum) {
        String str = null;
        Cell cell = this.getCell(rowNum, colNum);
        if (cell.getType() == CellType.LABEL) {
            LabelCell labelcell = (LabelCell)cell;
            str = labelcell.getString().trim();
        } else if (cell.getType() == CellType.NUMBER) {
            str = cell.getContents();
        } else if (cell.getType() == CellType.DATE) {
            DateCell datcell = (DateCell)cell;
            str = DateUtil.formatDate(datcell.getDate(), "yyyy-MM-dd");
        } else {
            str = cell.getContents().toString().trim();
        }
        return str;
    }

    public void close() {
        if (this.workbook != null) {
            this.workbook.close();
        }
    }
}

