/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.util.file.excel.jxl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import jxl.Workbook;
import jxl.format.CellFormat;
import jxl.read.biff.BiffException;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.apache.commons.beanutils.BeanUtils;
import org.nbone.util.WebIOUtils;
import org.nbone.util.file.excel.ExcelColumn;
import org.nbone.util.file.excel.jxl.ExcelOper;
import org.nbone.util.file.excel.jxl.FormatUtils;

public class ExcelUtils {
    public static WritableWorkbook createWorkbook(Object object) {
        WritableWorkbook wbook;
        block4: {
            wbook = null;
            try {
                if (object instanceof File) {
                    File file = (File)object;
                    wbook = Workbook.createWorkbook((File)file);
                    break block4;
                }
                if (object instanceof OutputStream) {
                    OutputStream os = (OutputStream)object;
                    wbook = Workbook.createWorkbook((OutputStream)os);
                    break block4;
                }
                throw new IllegalArgumentException("Please input File Object or OutputStream Object.");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return wbook;
    }

    public static Workbook getWorkbook(Object object) {
        Workbook wbook;
        block5: {
            wbook = null;
            try {
                if (object instanceof File) {
                    File file = (File)object;
                    wbook = Workbook.getWorkbook((File)file);
                    break block5;
                }
                if (object instanceof InputStream) {
                    InputStream ins = (InputStream)object;
                    wbook = Workbook.getWorkbook((InputStream)ins);
                    break block5;
                }
                throw new IllegalArgumentException("Please input File Object or InputStream Object.");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (BiffException e) {
                e.printStackTrace();
            }
        }
        return wbook;
    }

    public static void readExcelData(File file) throws Exception {
        ExcelOper eo = new ExcelOper(file);
        int colNum = eo.getCols();
        int rowNum = eo.getRows();
    }

    public static void export(Object object, String title, List<ExcelColumn> columns, List<Object> dataList) throws Exception {
        ExcelUtils.createExcelData(object, title, columns, dataList);
    }

    public static void export(HttpServletResponse response, String title, List<ExcelColumn> columns, List<Object> dataList) throws Exception {
        OutputStream os = WebIOUtils.getExcelOutputStream(response, title);
        ExcelUtils.createExcelData(os, title, columns, dataList);
    }

    private static void createExcelData(Object output, String title, List<ExcelColumn> columns, List<Object> dataList) throws Exception {
        try {
            Label wlabel;
            ExcelColumn column;
            WritableWorkbook wbook = ExcelUtils.createWorkbook(output);
            WritableSheet wsheet = wbook.createSheet(title, 0);
            FormatUtils.reinitialize();
            wsheet.mergeCells(0, 0, columns.size() - 1, 0);
            wsheet.mergeCells(0, 1, columns.size() - 1, 1);
            wsheet.addCell((WritableCell)new Label(0, 1, title, (CellFormat)FormatUtils.WCF_TITLE));
            for (int j = 0; j < columns.size(); ++j) {
                column = columns.get(j);
                wlabel = new Label(j, 2, column.getColumnTitle(), (CellFormat)FormatUtils.WCF_HEAD);
                wsheet.addCell((WritableCell)wlabel);
            }
            for (int i = 0; i < dataList.size(); ++i) {
                Object obj = dataList.get(i);
                for (int j = 0; j < columns.size(); ++j) {
                    column = columns.get(j);
                    wlabel = new Label(j, i + 3, BeanUtils.getProperty((Object)obj, (String)column.getColumnName()), (CellFormat)FormatUtils.WCF_CONTENT);
                    wsheet.setColumnView(j, column.getWidth());
                    wsheet.addCell((WritableCell)wlabel);
                }
            }
            wbook.write();
            wbook.close();
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        finally {
            WebIOUtils.close(output);
        }
    }
}

