/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.util.file.excel.poi;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.nbone.util.file.excel.ExcelTemplate;

public abstract class AbstractPoiExcelTemplate<T>
implements ExcelTemplate<T> {
    private static final int DEFAULT_COLUMN_WIDTH = 7000;
    protected Workbook workbook;
    protected List<Sheet> sheets = new ArrayList<Sheet>();
    protected String[][] titles;
    protected CellStyle captionRowSytle;
    protected CellStyle titleRowStyle;
    protected CellStyle bodyRowStyle;
    protected Map<Integer, Boolean> hasCaptionMap = new HashMap<Integer, Boolean>();
    protected int columnWidth = 7000;
    protected T parameters;

    @Override
    public void export(OutputStream outputStream, T parameters) throws IOException {
        Object[] sheetNames = this.getSheetNames();
        Validate.notEmpty((Object[])sheetNames);
        Validate.notNull((Object)outputStream);
        this.parameters = parameters;
        this.workbook = new SXSSFWorkbook(this.getRowAccessWindowSize());
        this.titles = this.getTitles();
        this.captionRowSytle = this.crateCaptionCellStyle();
        this.titleRowStyle = this.crateTitleCellStyle();
        this.bodyRowStyle = this.crateBodyCellStyle();
        this.afterCreateWorkBook();
        for (int i = 0; i < sheetNames.length; ++i) {
            Sheet sheet = this.workbook.createSheet((String)sheetNames[i]);
            this.sheets.add(sheet);
            this.afterBuildSheet(i);
            this.buildCaption(i);
            this.buildTitle(i);
            this.afterBuildTitle(i);
            this.buildBody(i);
            this.afterBuildBody(i);
        }
        this.workbook.write(outputStream);
    }

    protected void createStyledCell(Row row, int index, String cellValue, CellStyle cellStyle) {
        Cell cell = row.createCell(index);
        cell.setCellValue(cellValue);
        cell.setCellStyle(cellStyle);
    }

    protected void afterCreateWorkBook() {
    }

    protected CellStyle crateCaptionCellStyle() {
        Font font = this.workbook.createFont();
        font.setColor((short)Short.MAX_VALUE);
        CellStyle cellStyle = this.workbook.createCellStyle();
        cellStyle.setWrapText(false);
        font.setFontHeight((short)250);
        cellStyle.setFont(font);
        cellStyle.setFillForegroundColor(IndexedColors.BLUE_GREY.index);
        cellStyle.setFillPattern((short)1);
        cellStyle.setAlignment((short)2);
        return cellStyle;
    }

    protected CellStyle crateTitleCellStyle() {
        Font font = this.workbook.createFont();
        font.setColor((short)Short.MAX_VALUE);
        CellStyle cellStyle = this.workbook.createCellStyle();
        cellStyle.setWrapText(false);
        font.setFontHeight((short)250);
        cellStyle.setFont(font);
        cellStyle.setFillForegroundColor((short)54);
        cellStyle.setFillPattern((short)1);
        short border = 1;
        this.setCellBorder(cellStyle, border, border, border, border);
        cellStyle.setAlignment((short)1);
        return cellStyle;
    }

    protected void setCellBorder(CellStyle cellStyle, short top, short bottom, short left, short right) {
        cellStyle.setBorderBottom(bottom);
        cellStyle.setBorderLeft(left);
        cellStyle.setBorderRight(right);
        cellStyle.setBorderTop(top);
    }

    protected CellStyle crateBodyCellStyle() {
        Font font = this.workbook.createFont();
        CellStyle cellStyle = this.workbook.createCellStyle();
        cellStyle.setWrapText(false);
        cellStyle.setFont(font);
        cellStyle.setFillForegroundColor((short)9);
        cellStyle.setFillPattern((short)1);
        cellStyle.setAlignment((short)1);
        short border = 1;
        this.setCellBorder(cellStyle, border, border, border, border);
        return cellStyle;
    }

    protected Sheet getSheet(int sheetIndex) {
        return this.sheets.get(sheetIndex);
    }

    protected void afterBuildSheet(int sheetIndex) {
    }

    protected void buildCaption(int sheetIndex) {
        String caption;
        Sheet sheet = this.getSheet(sheetIndex);
        String[] captions = this.getCaptions();
        this.hasCaptionMap.put(sheetIndex, false);
        if (captions != null && captions.length >= sheetIndex + 1 && StringUtils.isNotBlank((String)(caption = captions[sheetIndex]))) {
            Row row = sheet.createRow(0);
            int lastColumn = this.calculateLastColumn(sheetIndex);
            CellRangeAddress cellRangeAddress = new CellRangeAddress(0, 0, 0, lastColumn);
            sheet.addMergedRegion(cellRangeAddress);
            this.createStyledCell(row, 0, caption, this.captionRowSytle);
            this.hasCaptionMap.put(sheetIndex, true);
        }
    }

    protected int calculateLastColumn(int sheetIndex) {
        if (this.titles != null && sheetIndex <= this.titles.length - 1 && this.titles[sheetIndex] != null) {
            return this.titles[sheetIndex].length - 1;
        }
        return 1;
    }

    protected void buildTitle(int sheetIndex) {
        if (this.titles.length < sheetIndex + 1) {
            return;
        }
        String[] ts = this.titles[sheetIndex];
        if (ts == null) {
            return;
        }
        Sheet sheet = this.getSheet(sheetIndex);
        int titleStartIndex = this.getTitleStartIndex(sheetIndex);
        Row rowTitle = sheet.createRow(titleStartIndex);
        for (int i = 0; i < ts.length; ++i) {
            sheet.setColumnWidth(i, this.columnWidth);
            this.createStyledCell(rowTitle, i, ts[i], this.titleRowStyle);
        }
    }

    protected int getBodyStartIndex(int sheetIndex) {
        int captionRow = this.getTitleStartIndex(sheetIndex);
        int titleRow = 0;
        if (this.titles != null && this.titles.length >= sheetIndex + 1 && this.titles[sheetIndex] != null && this.titles[sheetIndex].length > 0) {
            titleRow = 1;
        }
        return captionRow + titleRow;
    }

    protected int getTitleStartIndex(int sheetIndex) {
        return this.hasCaptionMap.get(sheetIndex) != false ? 1 : 0;
    }

    protected void afterBuildTitle(int sheetIndex) {
    }

    protected abstract void buildBody(int var1);

    protected void afterBuildBody(int sheetIndex) {
    }

    @Override
    public String[] getCaptions() {
        return new String[0];
    }

    public int getRowAccessWindowSize() {
        return 200;
    }

    public String toString(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }
}

