/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.util.http;

import java.io.IOException;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpC3Utils {
    private static Log logger = LogFactory.getLog(HttpC3Utils.class);
    public static final String URL_NET_SERVER_ERROR = "\u76ee\u6807\u5730\u5740\u9519\u8bef/\u7f51\u7edc\u5f02\u5e38/\u76ee\u6807\u670d\u52a1\u505c\u6b62,\u8bf7\u53ca\u65f6\u68c0\u67e5.";

    public static HttpClient getClient(int timeout) {
        HttpClient client = new HttpClient();
        client.setConnectionTimeout(timeout);
        return client;
    }

    public static HttpClient getClient() {
        HttpClient client = new HttpClient();
        return client;
    }

    public static boolean isServerStart(String url) {
        return HttpC3Utils.isServerStart(url, 5000);
    }

    public static boolean isServerStart(String url, int timeout) {
        long start = System.currentTimeMillis();
        HttpClient client = HttpC3Utils.getClient();
        if (timeout > 0) {
            client.setConnectionTimeout(timeout);
        }
        HttpMethod method = HttpC3Utils.doGet(client, url);
        int statusCode = 0;
        try {
            statusCode = method.getStatusCode();
        }
        catch (Exception e) {
            logger.error((Object)URL_NET_SERVER_ERROR, (Throwable)e);
        }
        HttpC3Utils.close(method);
        HttpC3Utils.close(client);
        long end = System.currentTimeMillis();
        long XX = end - start;
        logger.info((Object)new StringBuilder().append("[").append(url).append("]").append(" \u8bbf\u95ee\u65f6\u95f4:").append(XX).append("ms"));
        return statusCode == 200;
    }

    public static HttpMethod doGet(HttpClient client, String url) {
        if (client == null) {
            throw new NullPointerException("HttpClient is not null.");
        }
        GetMethod method = new GetMethod(url);
        try {
            int statusCode = client.executeMethod((HttpMethod)method);
            if (statusCode != 200) {
                logger.error((Object)method.getStatusLine());
                logger.error((Object)new StringBuilder("\u6b64\u670d\u52a1\u4e0d\u80fd\u8bbf\u95ee:").append(statusCode).append("\u9519\u8bef!URL:").append(url));
            }
        }
        catch (HttpException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return method;
    }

    public static String doGetAsString(String url, boolean isClose) {
        String responseText = null;
        HttpClient client = HttpC3Utils.getClient();
        HttpMethod method = HttpC3Utils.doGet(client, url);
        try {
            responseText = method.getResponseBodyAsString();
            if (isClose) {
                HttpC3Utils.close(method);
                HttpC3Utils.close(client);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return responseText;
    }

    public static String doGetAsString(String url) {
        return HttpC3Utils.doGetAsString(url, false);
    }

    public static HttpMethod doPost(HttpClient client, String url, NameValuePair[] params) {
        if (client == null) {
            throw new NullPointerException("HttpClient is not null.");
        }
        PostMethod method = new PostMethod(url);
        method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler());
        method.setRequestBody(params);
        try {
            int statusCode = client.executeMethod((HttpMethod)method);
            if (statusCode != 200) {
                logger.error((Object)method.getStatusLine());
                logger.error((Object)new StringBuilder("\u6b64\u670d\u52a1\u4e0d\u80fd\u8bbf\u95ee:").append(statusCode).append("\u9519\u8bef!URL:").append(url));
            }
        }
        catch (HttpException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return method;
    }

    public static String doPostAsString(String url, NameValuePair[] params, boolean isClose) {
        String responseText = null;
        HttpClient client = HttpC3Utils.getClient();
        HttpMethod method = HttpC3Utils.doPost(client, url, params);
        try {
            responseText = method.getResponseBodyAsString();
            if (isClose) {
                HttpC3Utils.close(method);
                HttpC3Utils.close(client);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return responseText;
    }

    public static String doPostAsString(String url, NameValuePair[] params) {
        return HttpC3Utils.doPostAsString(url, params, false);
    }

    public static void close(HttpMethod method) {
        if (method != null) {
            method.releaseConnection();
        }
    }

    public static void close(HttpClient client) {
        if (client != null) {
            client.getHttpConnectionManager().closeIdleConnections(0L);
        }
    }
}

