/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.util.http;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class HttpC4Utils {
    private static Log logger = LogFactory.getLog(HttpC4Utils.class);
    public static final String URL_NET_SERVER_ERROR = "\u76ee\u6807\u5730\u5740\u9519\u8bef/\u7f51\u7edc\u5f02\u5e38/\u76ee\u6807\u670d\u52a1\u505c\u6b62,\u8bf7\u53ca\u65f6\u68c0\u67e5.";
    public static String charset = "UTF-8";
    public static RequestConfig requestConfig;

    public static CloseableHttpClient getClient() {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        return httpclient;
    }

    public static RequestConfig customRequestConfig() {
        RequestConfig config = RequestConfig.custom().setSocketTimeout(1000).setConnectTimeout(5000).build();
        return config;
    }

    public static void setRequestConfig(RequestConfig config) {
        requestConfig = config;
    }

    public static boolean isServerStart(String url) {
        return HttpC4Utils.isServerStart(url, 5000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isServerStart(String url, int timeout) {
        long start = System.currentTimeMillis();
        CloseableHttpClient client = HttpC4Utils.getClient();
        CloseableHttpResponse response = null;
        int statusCode = 0;
        try {
            if (timeout > 0) {
                RequestConfig config;
                requestConfig = config = RequestConfig.custom().setConnectTimeout(timeout).build();
            }
            response = HttpC4Utils.doGet(client, url);
            statusCode = HttpC4Utils.getStatusCode((HttpResponse)response);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(response);
                HttpClientUtils.closeQuietly((HttpClient)client);
                requestConfig = null;
                throw throwable;
            }
            HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
            HttpClientUtils.closeQuietly((HttpClient)client);
            requestConfig = null;
        }
        HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
        HttpClientUtils.closeQuietly((HttpClient)client);
        requestConfig = null;
        long end = System.currentTimeMillis();
        long XX = end - start;
        logger.info((Object)new StringBuilder().append("[").append(url).append("]").append(" \u8bbf\u95ee\u65f6\u95f4:").append(XX).append("ms"));
        return statusCode == 200;
    }

    public static CloseableHttpResponse doGet(CloseableHttpClient client, String url) {
        if (client == null) {
            throw new NullPointerException("HttpClient is not null.");
        }
        HttpGet httpget = new HttpGet(url);
        if (requestConfig != null) {
            httpget.setConfig(requestConfig);
        }
        CloseableHttpResponse response = null;
        try {
            response = client.execute((HttpUriRequest)httpget);
            int statusCode = HttpC4Utils.getStatusCode((HttpResponse)response);
            if (statusCode != 200) {
                logger.error((Object)response.getStatusLine());
                logger.error((Object)new StringBuilder("\u6b64\u670d\u52a1\u4e0d\u80fd\u8bbf\u95ee:").append(statusCode).append("\u9519\u8bef!URL:").append(url));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGetAsString(String url, String charset, boolean isClose) {
        String responseText = null;
        CloseableHttpClient client = HttpC4Utils.getClient();
        CloseableHttpResponse response = HttpC4Utils.doGet(client, url);
        try {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                long responseLength = entity.getContentLength();
                responseText = EntityUtils.toString((HttpEntity)entity, (String)charset);
                EntityUtils.consume((HttpEntity)entity);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
            if (isClose) {
                HttpClientUtils.closeQuietly((HttpClient)client);
            }
        }
        return responseText;
    }

    public static String doGetAsString(String url, String charset) {
        return HttpC4Utils.doGetAsString(url, charset, false);
    }

    public static String doGetAsString(String url, boolean isClose) {
        return HttpC4Utils.doGetAsString(url, charset, isClose);
    }

    public static String doGetAsString(String url) {
        return HttpC4Utils.doGetAsString(url, charset, false);
    }

    public static CloseableHttpResponse doPost(CloseableHttpClient client, String url, List<NameValuePair> formParams, String charset) {
        if (client == null) {
            throw new NullPointerException("HttpClient is not null.");
        }
        HttpPost httppost = new HttpPost(url);
        if (requestConfig != null) {
            httppost.setConfig(requestConfig);
        }
        CloseableHttpResponse response = null;
        try {
            httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(formParams, charset));
            response = client.execute((HttpUriRequest)httppost);
            int statusCode = HttpC4Utils.getStatusCode((HttpResponse)response);
            if (statusCode != 200) {
                logger.error((Object)response.getStatusLine());
                logger.error((Object)new StringBuilder("\u6b64\u670d\u52a1\u4e0d\u80fd\u8bbf\u95ee:").append(statusCode).append("\u9519\u8bef!URL:").append(url));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPostAsString(String url, List<NameValuePair> formParams, String charset, boolean isClose) {
        String responseText = null;
        CloseableHttpClient client = HttpC4Utils.getClient();
        CloseableHttpResponse response = HttpC4Utils.doPost(client, url, formParams, charset);
        try {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                long responseLength = entity.getContentLength();
                responseText = EntityUtils.toString((HttpEntity)entity, (String)charset);
                EntityUtils.consume((HttpEntity)entity);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
            if (isClose) {
                HttpClientUtils.closeQuietly((HttpClient)client);
            }
        }
        return responseText;
    }

    public static String doPostAsString(String url, List<NameValuePair> formParams, String charset) {
        return HttpC4Utils.doPostAsString(url, formParams, charset, false);
    }

    public static String doPostAsString(String url, List<NameValuePair> formParams, boolean isClose) {
        return HttpC4Utils.doPostAsString(url, formParams, charset, isClose);
    }

    public static String doPostAsString(String url, List<NameValuePair> formParams) {
        return HttpC4Utils.doPostAsString(url, formParams, charset, false);
    }

    public static int getStatusCode(HttpResponse response) {
        if (response == null) {
            logger.error((Object)URL_NET_SERVER_ERROR);
            return -1;
        }
        int sc = response.getStatusLine().getStatusCode();
        return sc;
    }

    public static void close1(HttpClient client) {
        if (client == null) {
            return;
        }
        client.getConnectionManager().shutdown();
    }

    public static void main(String[] args) {
        System.out.println(HttpC4Utils.isServerStart("http://192.168.0.250:9000/hst"));
    }
}

