/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.util.json;

import java.lang.reflect.InvocationTargetException;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.ezmorph.Morpher;
import net.sf.ezmorph.MorpherRegistry;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonValueProcessor;
import net.sf.json.util.JSONUtils;
import net.sf.json.util.PropertyFilter;
import org.apache.commons.beanutils.BeanUtils;
import org.nbone.constants.DateConstant;
import org.nbone.util.json.EzmorphDateMorpher;
import org.nbone.util.json.EzmorphSqlDateMorpher;
import org.nbone.util.json.EzmorphSqlTimestampMorpher;
import org.nbone.util.json.JsonValueProcessorImpl;
import org.nbone.util.json.NullValuePropertyFilter;

public class JSONOperUtils
implements DateConstant {
    static JsonConfig jsonCfg = new JsonConfig();
    static JsonConfig jsonCfg1;

    public static <T> T JSONToObject(String json, Class<T> beanClz) {
        return JSONOperUtils.JSONToObject(json, beanClz, null);
    }

    public static <T> T JSONToObject(String json, Class<T> beanClz, Map classMap) {
        JSONObject jsonObject = JSONObject.fromObject((Object)json);
        Object bean = classMap == null ? JSONObject.toBean((JSONObject)jsonObject, beanClz) : JSONObject.toBean((JSONObject)jsonObject, beanClz, (Map)classMap);
        return (T)bean;
    }

    public static JSONObject JSONToJSONObject(String json) {
        JSONObject jsonObject = JSONObject.fromObject((Object)json);
        return jsonObject;
    }

    public static <T> Map<String, T> JSONToMapForBean(String json, Class<T> beanClz) {
        JSONObject jsonObject = JSONObject.fromObject((Object)json);
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator iter = jsonObject.keys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            map.put(key, JSONObject.toBean((JSONObject)jsonObject.getJSONObject(key), beanClz));
        }
        return map;
    }

    public static <T> Map<String, T> JSONToMapForBean(String json, Class<T> beanClz, Map classMap) {
        JSONObject jsonObject = JSONObject.fromObject((Object)json);
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator iter = jsonObject.keys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            map.put(key, JSONObject.toBean((JSONObject)jsonObject.getJSONObject(key), beanClz, (Map)classMap));
        }
        return map;
    }

    public static String[] JSON2StringArray(String json) {
        Object[] objArray = JSONOperUtils.JSONToArray(json);
        String[] result = new String[objArray.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = String.valueOf(objArray[i]);
        }
        return result;
    }

    public static Object[] JSONToArray(String json) {
        return JSONArray.fromObject((Object)json).toArray();
    }

    public static List<Object> JSONToList(String json) {
        JSONArray array = JSONArray.fromObject((Object)json);
        int size = array.size();
        ArrayList<Object> resultList = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            resultList.add(array.get(i));
        }
        return resultList;
    }

    public static <T> List<T> JSONToListForBean(String json, Class<T> clazz) {
        return JSONOperUtils.JSONToListForBean(json, clazz, null);
    }

    public static <T> List<T> JSONToListForBean(String json, Class<T> clazz, Map classMap) {
        JSONArray array = JSONArray.fromObject((Object)json);
        int size = array.size();
        ArrayList<Object> resultList = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            JSONObject jsonObject = array.getJSONObject(i);
            Object bean = null;
            bean = classMap == null ? JSONObject.toBean((JSONObject)jsonObject, clazz) : JSONObject.toBean((JSONObject)jsonObject, clazz, (Map)classMap);
            resultList.add(bean);
        }
        return resultList;
    }

    public static <T> Collection<T> toCollectionForBean(String json, Class<T> clazz) {
        JSONArray array = JSONArray.fromObject((Object)json);
        Collection collection = JSONArray.toCollection((JSONArray)array, clazz);
        return collection;
    }

    public static <T> T toJavaBean(String json, Class<T> beanClz, String[] highKeys) {
        JSONObject jsonObject = JSONObject.fromObject((Object)json);
        if (highKeys == null) {
            return (T)JSONObject.toBean((JSONObject)jsonObject, beanClz);
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (int i = 0; i < highKeys.length; ++i) {
            String key = highKeys[i];
            Object object = jsonObject.get(key);
            jsonObject.remove(key);
            properties.put(key, object);
        }
        Object result = JSONObject.toBean((JSONObject)jsonObject, beanClz);
        try {
            BeanUtils.populate((Object)result, properties);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return (T)result;
    }

    public static String pojoToJSON(Object obj, JsonConfig jsonConfig) {
        String jsonStr = null;
        if (obj == null) {
            return "{}";
        }
        jsonStr = obj instanceof Collection || obj instanceof Object[] || obj.getClass().isArray() ? JSONArray.fromObject((Object)obj, (JsonConfig)jsonConfig).toString() : JSONObject.fromObject((Object)obj, (JsonConfig)jsonConfig).toString();
        return jsonStr;
    }

    public static String pojoToJSON(Object obj) {
        return JSONOperUtils.pojoToJSON(obj, jsonCfg);
    }

    public static String pojoToJSONFilter(Object obj) {
        return JSONOperUtils.pojoToJSON(obj, jsonCfg1);
    }

    public static void main(String[] args) {
        String ss = "[0,1,2,3,{id=9},['l','oo']]";
        JSONArray array = JSONArray.fromObject((Object)ss);
        Collection coll = JSONArray.toCollection((JSONArray)array);
        System.out.println(JSONOperUtils.JSONToList(ss));
    }

    static {
        JsonValueProcessorImpl toJSONProcessor = new JsonValueProcessorImpl("yyyy-MM-dd HH:mm:ss");
        jsonCfg.registerJsonValueProcessor(java.util.Date.class, (JsonValueProcessor)toJSONProcessor);
        jsonCfg.registerJsonValueProcessor(Timestamp.class, (JsonValueProcessor)toJSONProcessor);
        jsonCfg.registerJsonValueProcessor(Date.class, (JsonValueProcessor)toJSONProcessor);
        MorpherRegistry mr = JSONUtils.getMorpherRegistry();
        String[] pattern = DEFAULT_FORMATS;
        EzmorphDateMorpher dateMorpher = new EzmorphDateMorpher(pattern);
        EzmorphSqlTimestampMorpher timestampMorpher = new EzmorphSqlTimestampMorpher(pattern);
        EzmorphSqlDateMorpher sqlDateMorpher = new EzmorphSqlDateMorpher(pattern);
        mr.registerMorpher((Morpher)dateMorpher);
        mr.registerMorpher((Morpher)timestampMorpher);
        mr.registerMorpher((Morpher)sqlDateMorpher);
        jsonCfg1 = new JsonConfig();
        jsonCfg1.setJsonPropertyFilter((PropertyFilter)new NullValuePropertyFilter());
    }
}

