/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.util.json;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Map;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import net.sf.json.xml.XMLSerializer;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import org.apache.commons.lang.StringUtils;

public class JSONXOperUtils {
    private static XMLSerializer xmlSerializer = new XMLSerializer();

    public static String pojo2XML(Object pojo, XMLSerializer xmlSer) {
        Object json = null;
        json = pojo instanceof Collection || pojo instanceof Object[] ? JSONArray.fromObject((Object)pojo) : JSONObject.fromObject((Object)pojo);
        if (xmlSer == null) {
            xmlSer = new XMLSerializer();
        }
        String xml = xmlSer.write((JSON)json);
        return xml;
    }

    public static String pojo2XML(Object pojo) {
        return JSONXOperUtils.pojo2XML(pojo, new XMLSerializer());
    }

    public static String json2XML(String p_json, XMLSerializer xmlSer) {
        JSONObject json = null;
        String xml = null;
        if (StringUtils.isNotEmpty((String)p_json)) {
            if (p_json.startsWith("{") && p_json.endsWith("}")) {
                json = JSONObject.fromObject((Object)p_json);
            } else if (p_json.startsWith("[") && p_json.endsWith("]")) {
                json = JSONArray.fromObject((Object)p_json);
            } else {
                throw new JSONException("A JSONObject text must begin with '{' or [");
            }
            if (xmlSer == null) {
                xmlSer = new XMLSerializer();
            }
            xml = xmlSer.write((JSON)json);
        }
        return xml;
    }

    public static String json2XML(String json) {
        return JSONXOperUtils.json2XML(json, new XMLSerializer());
    }

    public static String xml2JSON(String xml, boolean isRootArray) {
        if (isRootArray) {
            xml = JSONXOperUtils.setXmlRootAttrToArray(xml);
        }
        XMLSerializer xmlSer = new XMLSerializer();
        return xmlSer.read(xml).toString();
    }

    public static String xml2JSON(String xml) {
        return JSONXOperUtils.xml2JSON(xml, true);
    }

    public static Map xml2Map(String xml) {
        XMLSerializer xmlSer = new XMLSerializer();
        JSON json = xmlSer.read(xml);
        return (JSONObject)json;
    }

    public static Object[] xml2ArrayForMap(String xml) {
        XMLSerializer xmlSer = new XMLSerializer();
        JSON json = xmlSer.read(xml = JSONXOperUtils.setXmlRootAttrToArray(xml));
        if (json.isArray()) {
            return ((JSONArray)json).toArray();
        }
        return new Object[]{json};
    }

    public static Object[] xml2ArrayForObject(String xml, Class beanClass) {
        xml = JSONXOperUtils.setXmlRootAttrToArray(xml);
        XMLSerializer xmlSer = new XMLSerializer();
        JSON jsonArr = xmlSer.read(xml);
        Object[] objArr = new Object[jsonArr.size()];
        for (int i = 0; i < jsonArr.size(); ++i) {
            objArr[i] = JSONObject.toBean((JSONObject)((JSONArray)jsonArr).getJSONObject(i), (Class)beanClass);
        }
        return objArr;
    }

    private static String setXmlRootAttrToArray(String xml) {
        try {
            Document doc = new Builder().build((Reader)new StringReader(xml));
            Element root = doc.getRootElement();
            Attribute attr = root.getAttribute("class");
            root.addAttribute(new Attribute("class", "array"));
            xml = root.toXML();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return xml;
    }
}

