/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.util.json;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonValueProcessor;

public class JsonValueProcessorImpl
implements JsonValueProcessor {
    private String format = "yyyy-MM-dd HH:mm:ss";

    public JsonValueProcessorImpl() {
    }

    public JsonValueProcessorImpl(String format) {
        this.format = format;
    }

    public Object processArrayValue(Object value, JsonConfig jsonConfig) {
        int i;
        Date[] dates;
        SimpleDateFormat sf;
        String[] obj = new String[]{};
        if (value instanceof Date[]) {
            sf = new SimpleDateFormat(this.format);
            dates = (Date[])value;
            obj = new String[dates.length];
            for (i = 0; i < dates.length; ++i) {
                obj[i] = sf.format(dates[i]);
            }
        }
        if (value instanceof Timestamp[]) {
            sf = new SimpleDateFormat(this.format);
            dates = (Timestamp[])value;
            obj = new String[dates.length];
            for (i = 0; i < dates.length; ++i) {
                obj[i] = sf.format(dates[i]);
            }
        }
        if (value instanceof java.sql.Date[]) {
            sf = new SimpleDateFormat(this.format);
            dates = (java.sql.Date[])value;
            obj = new String[dates.length];
            for (i = 0; i < dates.length; ++i) {
                obj[i] = sf.format(dates[i]);
            }
        }
        return obj;
    }

    public Object processObjectValue(String key, Object value, JsonConfig jsonConfig) {
        if (value == null) {
            return "";
        }
        if (value instanceof Timestamp) {
            String str = new SimpleDateFormat(this.format).format((Timestamp)value);
            return str;
        }
        if (value instanceof Date) {
            String str = new SimpleDateFormat(this.format).format((Date)value);
            return str;
        }
        if (value instanceof java.sql.Date) {
            String str = new SimpleDateFormat(this.format).format((java.sql.Date)value);
            return str;
        }
        return String.valueOf(value);
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }
}

