/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.util.json.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.nbone.constants.DateConstant;
import org.nbone.util.json.jackson.CustomDateDeSerializer;
import org.nbone.util.json.jackson.CustomSqlDateDeSerializer;
import org.nbone.util.json.jackson.CustomSqlTimestampDeSerializer;
import org.nbone.util.json.jackson.ToJsonDateSerializer;
import org.nbone.util.json.jackson.ToJsonLongSerializer;
import org.nbone.util.json.jackson.ToJsonSqlTimestampSerializer;
import org.nbone.util.json.jackson.ToJsonStringSerializer;

public class JsonUtils
implements DateConstant {
    private static final ObjectMapper mapper;
    private static ObjectMapper mapper1;
    static final ObjectMapper objectMapper;
    static boolean isPretty;

    public static ObjectMapper newInstance() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        SimpleModule module = new SimpleModule("JsonUtil", new Version(1, 0, 0, null));
        module.addSerializer((JsonSerializer)new ToJsonLongSerializer());
        module.addSerializer((JsonSerializer)new ToJsonSqlTimestampSerializer("yyyy-MM-dd HH:mm:ss"));
        module.addSerializer((JsonSerializer)new ToJsonDateSerializer("yyyy-MM-dd HH:mm:ss"));
        module.addSerializer((JsonSerializer)new ToJsonStringSerializer());
        module.addDeserializer(java.util.Date.class, (JsonDeserializer)new CustomDateDeSerializer(java.util.Date.class, DEFAULT_FORMATS));
        module.addDeserializer(Timestamp.class, (JsonDeserializer)new CustomSqlTimestampDeSerializer(Timestamp.class, DEFAULT_FORMATS));
        module.addDeserializer(Date.class, (JsonDeserializer)new CustomSqlDateDeSerializer(Date.class, DEFAULT_FORMATS));
        mapper.registerModule((Module)module);
        return mapper;
    }

    private ObjectMapper getMapper() {
        return mapper;
    }

    public static <T> T toObjectFromJson(String json, Class<T> clazz) throws Exception {
        return (T)mapper.readValue(json, clazz);
    }

    public static <T> T toObjectFromJson(String json, TypeReference<T> typeRef) throws Exception {
        return (T)mapper.readValue(json, typeRef);
    }

    public static <T> T convertValue(Object fromValue, Class<T> toValueType) throws Exception {
        return (T)mapper.convertValue(fromValue, toValueType);
    }

    public static <T> T convertValue(Object fromValue, TypeReference<T> toValueTypeRef) throws Exception {
        return (T)mapper.convertValue(fromValue, toValueTypeRef);
    }

    public static String pojoToJson(Object value) throws Exception {
        mapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        return mapper.writeValueAsString(value);
    }

    public static String pojoToJsonFilter(Object value) throws Exception {
        mapper1.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return mapper1.writeValueAsString(value);
    }

    static {
        mapper1 = new ObjectMapper();
        mapper = JsonUtils.newInstance();
        isPretty = true;
        DefaultSerializerProvider.Impl sp = new DefaultSerializerProvider.Impl();
        objectMapper = new ObjectMapper(null, (DefaultSerializerProvider)sp, null);
        objectMapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
        objectMapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        SimpleModule module = new SimpleModule("myCustomerModule", new Version(1, 0, 0, null));
        module.addDeserializer(java.util.Date.class, (JsonDeserializer)new CustomDateDeSerializer(java.util.Date.class, DEFAULT_FORMATS));
        objectMapper.registerModule((Module)module);
        objectMapper.registerModule((Module)module);
    }
}

