/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.util.json.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ToJsonDateSerializer
extends JsonSerializer<Date> {
    private String pattern;
    private SimpleDateFormat dateFormat;

    public ToJsonDateSerializer(String pattern) {
        this.pattern = pattern;
        this.dateFormat = new SimpleDateFormat();
    }

    public Class<Date> handledType() {
        return Date.class;
    }

    public void serialize(Date value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
        this.dateFormat.applyPattern(this.pattern);
        gen.writeString(String.valueOf(this.dateFormat.format(value)));
    }
}

