/*
 * Decompiled with CFR 0.152.
 */
package org.nbone.util.json.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;

public class ToJsonSqlTimestampSerializer
extends JsonSerializer<Timestamp> {
    private String pattern;
    private SimpleDateFormat dateFormat;

    public ToJsonSqlTimestampSerializer(String pattern) {
        this.pattern = pattern;
        this.dateFormat = new SimpleDateFormat();
    }

    public Class<Timestamp> handledType() {
        return Timestamp.class;
    }

    public void serialize(Timestamp value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
        this.dateFormat.applyPattern(this.pattern);
        gen.writeString(String.valueOf(this.dateFormat.format(value)));
    }
}

